@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.ClusterBootstrapActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arg bootstrap action args, e.g. "--a=b".
 * @property executionFailStrategy bootstrap action execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ . Default value: "FAILED_BLOCKED
 * @property executionMoment bootstrap action execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ . Default value: "BEFORE_INSTALL".
 * @property executionTarget bootstrap action execution target, you can specify the host group name, e.g. "core_group". If this is not specified, the bootstrap action execution target is whole cluster.
 * @property name The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
 * @property path bootstrap action path, e.g. "oss://bucket/path".
 */
public data class ClusterBootstrapActionArgs(
    public val arg: Output<String>? = null,
    public val executionFailStrategy: Output<String>? = null,
    public val executionMoment: Output<String>? = null,
    public val executionTarget: Output<String>? = null,
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.ClusterBootstrapActionArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.ClusterBootstrapActionArgs =
        com.pulumi.alicloud.emr.inputs.ClusterBootstrapActionArgs.builder()
            .arg(arg?.applyValue({ args0 -> args0 }))
            .executionFailStrategy(executionFailStrategy?.applyValue({ args0 -> args0 }))
            .executionMoment(executionMoment?.applyValue({ args0 -> args0 }))
            .executionTarget(executionTarget?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBootstrapActionArgs].
 */
@PulumiTagMarker
public class ClusterBootstrapActionArgsBuilder internal constructor() {
    private var arg: Output<String>? = null

    private var executionFailStrategy: Output<String>? = null

    private var executionMoment: Output<String>? = null

    private var executionTarget: Output<String>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value bootstrap action args, e.g. "--a=b".
     */
    @JvmName("kdotfqdckovhtewc")
    public suspend fun arg(`value`: Output<String>) {
        this.arg = value
    }

    /**
     * @param value bootstrap action execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ . Default value: "FAILED_BLOCKED
     */
    @JvmName("uhwhomfnxlkqpjgs")
    public suspend fun executionFailStrategy(`value`: Output<String>) {
        this.executionFailStrategy = value
    }

    /**
     * @param value bootstrap action execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ . Default value: "BEFORE_INSTALL".
     */
    @JvmName("wwdfqjwtbufmqwbh")
    public suspend fun executionMoment(`value`: Output<String>) {
        this.executionMoment = value
    }

    /**
     * @param value bootstrap action execution target, you can specify the host group name, e.g. "core_group". If this is not specified, the bootstrap action execution target is whole cluster.
     */
    @JvmName("fwftdxpmajrkeqva")
    public suspend fun executionTarget(`value`: Output<String>) {
        this.executionTarget = value
    }

    /**
     * @param value The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
     */
    @JvmName("iggwgrrcqjkukiyr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value bootstrap action path, e.g. "oss://bucket/path".
     */
    @JvmName("gbcnwohkkcoomqvb")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value bootstrap action args, e.g. "--a=b".
     */
    @JvmName("orwxafypepxryacg")
    public suspend fun arg(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arg = mapped
    }

    /**
     * @param value bootstrap action execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ . Default value: "FAILED_BLOCKED
     */
    @JvmName("haldcopkwnwluorx")
    public suspend fun executionFailStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionFailStrategy = mapped
    }

    /**
     * @param value bootstrap action execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ . Default value: "BEFORE_INSTALL".
     */
    @JvmName("bipjirnqprbrrype")
    public suspend fun executionMoment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionMoment = mapped
    }

    /**
     * @param value bootstrap action execution target, you can specify the host group name, e.g. "core_group". If this is not specified, the bootstrap action execution target is whole cluster.
     */
    @JvmName("jnkhlxwjiawgdnbu")
    public suspend fun executionTarget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionTarget = mapped
    }

    /**
     * @param value The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
     */
    @JvmName("tpimknmlccpuojkf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value bootstrap action path, e.g. "oss://bucket/path".
     */
    @JvmName("oeygirejdgchotlr")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): ClusterBootstrapActionArgs = ClusterBootstrapActionArgs(
        arg = arg,
        executionFailStrategy = executionFailStrategy,
        executionMoment = executionMoment,
        executionTarget = executionTarget,
        name = name,
        path = path,
    )
}
