@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.ClusterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configKey Custom configuration service config key, e.g. ’dfs.replication’.
 * @property configValue Custom configuration service config value, e.g. ’3’.
 * @property fileName Custom configuration service file name, e.g. ’hdfs-site’.
 * @property serviceName
 */
public data class ClusterConfigArgs(
    public val configKey: Output<String>,
    public val configValue: Output<String>,
    public val fileName: Output<String>,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.ClusterConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.ClusterConfigArgs =
        com.pulumi.alicloud.emr.inputs.ClusterConfigArgs.builder()
            .configKey(configKey.applyValue({ args0 -> args0 }))
            .configValue(configValue.applyValue({ args0 -> args0 }))
            .fileName(fileName.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterConfigArgs].
 */
@PulumiTagMarker
public class ClusterConfigArgsBuilder internal constructor() {
    private var configKey: Output<String>? = null

    private var configValue: Output<String>? = null

    private var fileName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Custom configuration service config key, e.g. ’dfs.replication’.
     */
    @JvmName("gcyrtgwqcymhwdrn")
    public suspend fun configKey(`value`: Output<String>) {
        this.configKey = value
    }

    /**
     * @param value Custom configuration service config value, e.g. ’3’.
     */
    @JvmName("tjcrkijtnaygmblp")
    public suspend fun configValue(`value`: Output<String>) {
        this.configValue = value
    }

    /**
     * @param value Custom configuration service file name, e.g. ’hdfs-site’.
     */
    @JvmName("npnxsvhtkwymwahf")
    public suspend fun fileName(`value`: Output<String>) {
        this.fileName = value
    }

    /**
     * @param value
     */
    @JvmName("kpvjsvlnlctccenp")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Custom configuration service config key, e.g. ’dfs.replication’.
     */
    @JvmName("hwjdavssleyukanu")
    public suspend fun configKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configKey = mapped
    }

    /**
     * @param value Custom configuration service config value, e.g. ’3’.
     */
    @JvmName("rfisphcrsyybgddg")
    public suspend fun configValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configValue = mapped
    }

    /**
     * @param value Custom configuration service file name, e.g. ’hdfs-site’.
     */
    @JvmName("qhcmjbxqhrjvaslj")
    public suspend fun fileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value
     */
    @JvmName("pdccuhedutknudfk")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ClusterConfigArgs = ClusterConfigArgs(
        configKey = configKey ?: throw PulumiNullFieldException("configKey"),
        configValue = configValue ?: throw PulumiNullFieldException("configValue"),
        fileName = fileName ?: throw PulumiNullFieldException("fileName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
