@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.ClusterHostGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoRenew Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
 * @property chargeType Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
 * @property decommissionTimeout Graceful decommission timeout, unit: seconds.
 * @property diskCapacity Data disk capacity.
 * @property diskCount Data disk count.
 * @property diskType Data disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,local_disk,cloud_essd.
 * @property enableGracefulDecommission Enable hadoop cluster of task node graceful decommission, ’true’ or ‘false’ . Default value: false.
 * @property gpuDriver
 * @property hostGroupName host group name.
 * @property hostGroupType host group type, supported value: MASTER, CORE or TASK, supported 'GATEWAY' available in 1.61.0+.
 * @property instanceList Instance list for cluster scale down. This value follows the json format, e.g. ["instance_id1","instance_id2"]. escape character for " is \".
 * @property instanceType Host Ecs instance type.
 * @property nodeCount Host number in this group.
 * @property period If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
 * @property sysDiskCapacity System disk capacity.
 * @property sysDiskType System disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,cloud_essd.
 */
public data class ClusterHostGroupArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val chargeType: Output<String>? = null,
    public val decommissionTimeout: Output<Int>? = null,
    public val diskCapacity: Output<String>? = null,
    public val diskCount: Output<String>? = null,
    public val diskType: Output<String>? = null,
    public val enableGracefulDecommission: Output<Boolean>? = null,
    public val gpuDriver: Output<String>? = null,
    public val hostGroupName: Output<String>? = null,
    public val hostGroupType: Output<String>? = null,
    public val instanceList: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val nodeCount: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val sysDiskCapacity: Output<String>? = null,
    public val sysDiskType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.ClusterHostGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.ClusterHostGroupArgs =
        com.pulumi.alicloud.emr.inputs.ClusterHostGroupArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .chargeType(chargeType?.applyValue({ args0 -> args0 }))
            .decommissionTimeout(decommissionTimeout?.applyValue({ args0 -> args0 }))
            .diskCapacity(diskCapacity?.applyValue({ args0 -> args0 }))
            .diskCount(diskCount?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .enableGracefulDecommission(enableGracefulDecommission?.applyValue({ args0 -> args0 }))
            .gpuDriver(gpuDriver?.applyValue({ args0 -> args0 }))
            .hostGroupName(hostGroupName?.applyValue({ args0 -> args0 }))
            .hostGroupType(hostGroupType?.applyValue({ args0 -> args0 }))
            .instanceList(instanceList?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .sysDiskCapacity(sysDiskCapacity?.applyValue({ args0 -> args0 }))
            .sysDiskType(sysDiskType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterHostGroupArgs].
 */
@PulumiTagMarker
public class ClusterHostGroupArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var chargeType: Output<String>? = null

    private var decommissionTimeout: Output<Int>? = null

    private var diskCapacity: Output<String>? = null

    private var diskCount: Output<String>? = null

    private var diskType: Output<String>? = null

    private var enableGracefulDecommission: Output<Boolean>? = null

    private var gpuDriver: Output<String>? = null

    private var hostGroupName: Output<String>? = null

    private var hostGroupType: Output<String>? = null

    private var instanceList: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var nodeCount: Output<String>? = null

    private var period: Output<Int>? = null

    private var sysDiskCapacity: Output<String>? = null

    private var sysDiskType: Output<String>? = null

    /**
     * @param value Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
     */
    @JvmName("hncuuqawobmgdlgu")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
     */
    @JvmName("ysyaerlnfcfenfvs")
    public suspend fun chargeType(`value`: Output<String>) {
        this.chargeType = value
    }

    /**
     * @param value Graceful decommission timeout, unit: seconds.
     */
    @JvmName("vfntbkdixkydhela")
    public suspend fun decommissionTimeout(`value`: Output<Int>) {
        this.decommissionTimeout = value
    }

    /**
     * @param value Data disk capacity.
     */
    @JvmName("nppvppjueumhckch")
    public suspend fun diskCapacity(`value`: Output<String>) {
        this.diskCapacity = value
    }

    /**
     * @param value Data disk count.
     */
    @JvmName("dwrcrtskcivgkmka")
    public suspend fun diskCount(`value`: Output<String>) {
        this.diskCount = value
    }

    /**
     * @param value Data disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,local_disk,cloud_essd.
     */
    @JvmName("blxeqkjdpumjfntr")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value Enable hadoop cluster of task node graceful decommission, ’true’ or ‘false’ . Default value: false.
     */
    @JvmName("opdupbsorigldbth")
    public suspend fun enableGracefulDecommission(`value`: Output<Boolean>) {
        this.enableGracefulDecommission = value
    }

    /**
     * @param value
     */
    @JvmName("uytmnqvmkvaybgnt")
    public suspend fun gpuDriver(`value`: Output<String>) {
        this.gpuDriver = value
    }

    /**
     * @param value host group name.
     */
    @JvmName("qbwfcwxoskevqwke")
    public suspend fun hostGroupName(`value`: Output<String>) {
        this.hostGroupName = value
    }

    /**
     * @param value host group type, supported value: MASTER, CORE or TASK, supported 'GATEWAY' available in 1.61.0+.
     */
    @JvmName("qcumcaqtxveixybx")
    public suspend fun hostGroupType(`value`: Output<String>) {
        this.hostGroupType = value
    }

    /**
     * @param value Instance list for cluster scale down. This value follows the json format, e.g. ["instance_id1","instance_id2"]. escape character for " is \".
     */
    @JvmName("oceineymtoceptoj")
    public suspend fun instanceList(`value`: Output<String>) {
        this.instanceList = value
    }

    /**
     * @param value Host Ecs instance type.
     */
    @JvmName("kcmdmwuxeiomjbip")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Host number in this group.
     */
    @JvmName("vspijristwygeiab")
    public suspend fun nodeCount(`value`: Output<String>) {
        this.nodeCount = value
    }

    /**
     * @param value If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
     */
    @JvmName("vrlfdwfrdalavibb")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value System disk capacity.
     */
    @JvmName("jyvrdraxnmdipejm")
    public suspend fun sysDiskCapacity(`value`: Output<String>) {
        this.sysDiskCapacity = value
    }

    /**
     * @param value System disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,cloud_essd.
     */
    @JvmName("xwwlqwsypmnmsnrs")
    public suspend fun sysDiskType(`value`: Output<String>) {
        this.sysDiskType = value
    }

    /**
     * @param value Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
     */
    @JvmName("slqdrxhcarsxpplt")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
     */
    @JvmName("nooqkuyktodapvli")
    public suspend fun chargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chargeType = mapped
    }

    /**
     * @param value Graceful decommission timeout, unit: seconds.
     */
    @JvmName("vyqhcshsgncnmoyi")
    public suspend fun decommissionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decommissionTimeout = mapped
    }

    /**
     * @param value Data disk capacity.
     */
    @JvmName("dxwavbmgtrqjhchm")
    public suspend fun diskCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCapacity = mapped
    }

    /**
     * @param value Data disk count.
     */
    @JvmName("jenfvigaftfjiuti")
    public suspend fun diskCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCount = mapped
    }

    /**
     * @param value Data disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,local_disk,cloud_essd.
     */
    @JvmName("angexhbbbsydhotb")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value Enable hadoop cluster of task node graceful decommission, ’true’ or ‘false’ . Default value: false.
     */
    @JvmName("kyjgdrmbdsqpcjnl")
    public suspend fun enableGracefulDecommission(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableGracefulDecommission = mapped
    }

    /**
     * @param value
     */
    @JvmName("fxvrfygfffxlxkoe")
    public suspend fun gpuDriver(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpuDriver = mapped
    }

    /**
     * @param value host group name.
     */
    @JvmName("dofghmqycxpqilfw")
    public suspend fun hostGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroupName = mapped
    }

    /**
     * @param value host group type, supported value: MASTER, CORE or TASK, supported 'GATEWAY' available in 1.61.0+.
     */
    @JvmName("ddseytuikplimnpr")
    public suspend fun hostGroupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroupType = mapped
    }

    /**
     * @param value Instance list for cluster scale down. This value follows the json format, e.g. ["instance_id1","instance_id2"]. escape character for " is \".
     */
    @JvmName("noyfbdpmagnkxldi")
    public suspend fun instanceList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceList = mapped
    }

    /**
     * @param value Host Ecs instance type.
     */
    @JvmName("ycuvgvadjhfnuqql")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Host number in this group.
     */
    @JvmName("kvntyapmbqbfbhxg")
    public suspend fun nodeCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
     */
    @JvmName("roxtdjlkvuuoqaox")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value System disk capacity.
     */
    @JvmName("bwkywquqpqtkvxmv")
    public suspend fun sysDiskCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sysDiskCapacity = mapped
    }

    /**
     * @param value System disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,cloud_essd.
     */
    @JvmName("ptsepmkqcmmugbpl")
    public suspend fun sysDiskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sysDiskType = mapped
    }

    internal fun build(): ClusterHostGroupArgs = ClusterHostGroupArgs(
        autoRenew = autoRenew,
        chargeType = chargeType,
        decommissionTimeout = decommissionTimeout,
        diskCapacity = diskCapacity,
        diskCount = diskCount,
        diskType = diskType,
        enableGracefulDecommission = enableGracefulDecommission,
        gpuDriver = gpuDriver,
        hostGroupName = hostGroupName,
        hostGroupType = hostGroupType,
        instanceList = instanceList,
        instanceType = instanceType,
        nodeCount = nodeCount,
        period = period,
        sysDiskCapacity = sysDiskCapacity,
        sysDiskType = sysDiskType,
    )
}
