@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.ClusterMetaStoreConfArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dbPassword Custom rds database password.
 * @property dbUrl Custom rds database connection url.
 * @property dbUserName Custom rds database user name.
 */
public data class ClusterMetaStoreConfArgs(
    public val dbPassword: Output<String>,
    public val dbUrl: Output<String>,
    public val dbUserName: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.ClusterMetaStoreConfArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.ClusterMetaStoreConfArgs =
        com.pulumi.alicloud.emr.inputs.ClusterMetaStoreConfArgs.builder()
            .dbPassword(dbPassword.applyValue({ args0 -> args0 }))
            .dbUrl(dbUrl.applyValue({ args0 -> args0 }))
            .dbUserName(dbUserName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterMetaStoreConfArgs].
 */
@PulumiTagMarker
public class ClusterMetaStoreConfArgsBuilder internal constructor() {
    private var dbPassword: Output<String>? = null

    private var dbUrl: Output<String>? = null

    private var dbUserName: Output<String>? = null

    /**
     * @param value Custom rds database password.
     */
    @JvmName("yqitkoeqjtlaewpg")
    public suspend fun dbPassword(`value`: Output<String>) {
        this.dbPassword = value
    }

    /**
     * @param value Custom rds database connection url.
     */
    @JvmName("xpbcctlgdwetaexx")
    public suspend fun dbUrl(`value`: Output<String>) {
        this.dbUrl = value
    }

    /**
     * @param value Custom rds database user name.
     */
    @JvmName("fhxsqkiprhdpugxt")
    public suspend fun dbUserName(`value`: Output<String>) {
        this.dbUserName = value
    }

    /**
     * @param value Custom rds database password.
     */
    @JvmName("okrsdnqrsbbjnhbe")
    public suspend fun dbPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbPassword = mapped
    }

    /**
     * @param value Custom rds database connection url.
     */
    @JvmName("oocuswfyltjjhpkd")
    public suspend fun dbUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbUrl = mapped
    }

    /**
     * @param value Custom rds database user name.
     */
    @JvmName("rlvjfsmvfktrukjq")
    public suspend fun dbUserName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbUserName = mapped
    }

    internal fun build(): ClusterMetaStoreConfArgs = ClusterMetaStoreConfArgs(
        dbPassword = dbPassword ?: throw PulumiNullFieldException("dbPassword"),
        dbUrl = dbUrl ?: throw PulumiNullFieldException("dbUrl"),
        dbUserName = dbUserName ?: throw PulumiNullFieldException("dbUserName"),
    )
}
