@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.ClusterModifyClusterServiceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comment Cluster service configuration modification comment, e.g. "Modify tez configuration".
 * @property configParams Cluster service configuration modification params, e.g. ’{"hdfs-site":{"dfs.replication":"3"}}’.
 * @property configType Cluster service configuration modification type.
 * @property customConfigParams Cluster service configuration modification custom params, e.g. ’{"tez-site":{"key":{"Value":"value"}}}’.
 * @property gatewayClusterIdLists Cluster service configuration modification related gateway cluster id list.
 * @property groupId Cluster service configuration modification node group id, e.g. ’G-XXX’.
 * @property hostInstanceId Cluster service configuration modification host instance id, e.g. ’i-bp146tnrkq4tcxxxxx’.
 * @property refreshHostConfig Cluster service configuration modification refresh host config, ’true’ or ’false’.
 * @property serviceName
 */
public data class ClusterModifyClusterServiceConfigArgs(
    public val comment: Output<String>? = null,
    public val configParams: Output<String>,
    public val configType: Output<String>? = null,
    public val customConfigParams: Output<String>? = null,
    public val gatewayClusterIdLists: Output<List<String>>? = null,
    public val groupId: Output<String>? = null,
    public val hostInstanceId: Output<String>? = null,
    public val refreshHostConfig: Output<Boolean>? = null,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.ClusterModifyClusterServiceConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.ClusterModifyClusterServiceConfigArgs =
        com.pulumi.alicloud.emr.inputs.ClusterModifyClusterServiceConfigArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .configParams(configParams.applyValue({ args0 -> args0 }))
            .configType(configType?.applyValue({ args0 -> args0 }))
            .customConfigParams(customConfigParams?.applyValue({ args0 -> args0 }))
            .gatewayClusterIdLists(gatewayClusterIdLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .hostInstanceId(hostInstanceId?.applyValue({ args0 -> args0 }))
            .refreshHostConfig(refreshHostConfig?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterModifyClusterServiceConfigArgs].
 */
@PulumiTagMarker
public class ClusterModifyClusterServiceConfigArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var configParams: Output<String>? = null

    private var configType: Output<String>? = null

    private var customConfigParams: Output<String>? = null

    private var gatewayClusterIdLists: Output<List<String>>? = null

    private var groupId: Output<String>? = null

    private var hostInstanceId: Output<String>? = null

    private var refreshHostConfig: Output<Boolean>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Cluster service configuration modification comment, e.g. "Modify tez configuration".
     */
    @JvmName("oawubtplxpmirmcq")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Cluster service configuration modification params, e.g. ’{"hdfs-site":{"dfs.replication":"3"}}’.
     */
    @JvmName("nvbpuubtoeisrimf")
    public suspend fun configParams(`value`: Output<String>) {
        this.configParams = value
    }

    /**
     * @param value Cluster service configuration modification type.
     */
    @JvmName("micwvvgoijpwfblv")
    public suspend fun configType(`value`: Output<String>) {
        this.configType = value
    }

    /**
     * @param value Cluster service configuration modification custom params, e.g. ’{"tez-site":{"key":{"Value":"value"}}}’.
     */
    @JvmName("spwvpdovmyfprqwy")
    public suspend fun customConfigParams(`value`: Output<String>) {
        this.customConfigParams = value
    }

    /**
     * @param value Cluster service configuration modification related gateway cluster id list.
     */
    @JvmName("mbsbhknltfudjsxh")
    public suspend fun gatewayClusterIdLists(`value`: Output<List<String>>) {
        this.gatewayClusterIdLists = value
    }

    @JvmName("grsralpcikegquec")
    public suspend fun gatewayClusterIdLists(vararg values: Output<String>) {
        this.gatewayClusterIdLists = Output.all(values.asList())
    }

    /**
     * @param values Cluster service configuration modification related gateway cluster id list.
     */
    @JvmName("owpnlyymdvpjndxf")
    public suspend fun gatewayClusterIdLists(values: List<Output<String>>) {
        this.gatewayClusterIdLists = Output.all(values)
    }

    /**
     * @param value Cluster service configuration modification node group id, e.g. ’G-XXX’.
     */
    @JvmName("cfcoeafhqlikvxwy")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Cluster service configuration modification host instance id, e.g. ’i-bp146tnrkq4tcxxxxx’.
     */
    @JvmName("fdrhgpnhdjppwunh")
    public suspend fun hostInstanceId(`value`: Output<String>) {
        this.hostInstanceId = value
    }

    /**
     * @param value Cluster service configuration modification refresh host config, ’true’ or ’false’.
     */
    @JvmName("gmfljpxuvqgjsdqk")
    public suspend fun refreshHostConfig(`value`: Output<Boolean>) {
        this.refreshHostConfig = value
    }

    /**
     * @param value
     */
    @JvmName("goyibdmxvwuqghua")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Cluster service configuration modification comment, e.g. "Modify tez configuration".
     */
    @JvmName("fadhbejilqlukdff")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Cluster service configuration modification params, e.g. ’{"hdfs-site":{"dfs.replication":"3"}}’.
     */
    @JvmName("ilisnbndcsuatghp")
    public suspend fun configParams(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configParams = mapped
    }

    /**
     * @param value Cluster service configuration modification type.
     */
    @JvmName("lnxrivskuusqptlr")
    public suspend fun configType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configType = mapped
    }

    /**
     * @param value Cluster service configuration modification custom params, e.g. ’{"tez-site":{"key":{"Value":"value"}}}’.
     */
    @JvmName("pwjyywpsrskoceel")
    public suspend fun customConfigParams(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConfigParams = mapped
    }

    /**
     * @param value Cluster service configuration modification related gateway cluster id list.
     */
    @JvmName("smeanrubrysaslbi")
    public suspend fun gatewayClusterIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayClusterIdLists = mapped
    }

    /**
     * @param values Cluster service configuration modification related gateway cluster id list.
     */
    @JvmName("liieqnutdbsuissv")
    public suspend fun gatewayClusterIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayClusterIdLists = mapped
    }

    /**
     * @param value Cluster service configuration modification node group id, e.g. ’G-XXX’.
     */
    @JvmName("nwwcxrngwehigglc")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Cluster service configuration modification host instance id, e.g. ’i-bp146tnrkq4tcxxxxx’.
     */
    @JvmName("emtnnskrcikljkel")
    public suspend fun hostInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostInstanceId = mapped
    }

    /**
     * @param value Cluster service configuration modification refresh host config, ’true’ or ’false’.
     */
    @JvmName("rcjvalojukbnmmpk")
    public suspend fun refreshHostConfig(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshHostConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("hpsuammdqhxkpqdm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ClusterModifyClusterServiceConfigArgs =
        ClusterModifyClusterServiceConfigArgs(
            comment = comment,
            configParams = configParams ?: throw PulumiNullFieldException("configParams"),
            configType = configType,
            customConfigParams = customConfigParams,
            gatewayClusterIdLists = gatewayClusterIdLists,
            groupId = groupId,
            hostInstanceId = hostInstanceId,
            refreshHostConfig = refreshHostConfig,
            serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        )
}
