@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.GetClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusters.
 * @property clusterName The cluster name.
 * @property clusterTypeLists The cluster type list.
 * @property createType How to create a cluster. Valid values: `ON-DEMAND`, `MANUAL`.
 * @property defaultStatus The default status.
 * @property depositType The hosting type of the cluster. Valid values: `HALF_MANAGED`, `MANAGED`.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Cluster IDs.
 * @property isDesc The is desc.
 * @property machineType The host type of the cluster. The default is ECS. Valid values: `DOCKER`, `ECS`, `PYHSICAL_MACHINE`, `ECS_FROM_ECM_HOSTPOOL`.
 * @property nameRegex A regex string to filter results by Cluster name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId The Resource Group ID.
 * @property statusLists The status list. Valid values: `ABNORMAL`, `CREATE_FAILED`, `CREATING`, `IDLE`, `RELEASED`, `RELEASE_FAILED`, `RELEASING`, `RUNNING`, `WAIT_FOR_PAY`.
 * @property vpcId The VPC ID.
 */
public data class GetClustersPlainArgs(
    public val clusterName: String? = null,
    public val clusterTypeLists: List<String>? = null,
    public val createType: String? = null,
    public val defaultStatus: Boolean? = null,
    public val depositType: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val isDesc: Boolean? = null,
    public val machineType: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val statusLists: List<String>? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.GetClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.GetClustersPlainArgs =
        com.pulumi.alicloud.emr.inputs.GetClustersPlainArgs.builder()
            .clusterName(clusterName?.let({ args0 -> args0 }))
            .clusterTypeLists(clusterTypeLists?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .createType(createType?.let({ args0 -> args0 }))
            .defaultStatus(defaultStatus?.let({ args0 -> args0 }))
            .depositType(depositType?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isDesc(isDesc?.let({ args0 -> args0 }))
            .machineType(machineType?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .statusLists(statusLists?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClustersPlainArgs].
 */
@PulumiTagMarker
public class GetClustersPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var clusterTypeLists: List<String>? = null

    private var createType: String? = null

    private var defaultStatus: Boolean? = null

    private var depositType: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var isDesc: Boolean? = null

    private var machineType: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var resourceGroupId: String? = null

    private var statusLists: List<String>? = null

    private var vpcId: String? = null

    /**
     * @param value The cluster name.
     */
    @JvmName("hpdfuvlkyixywmhb")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The cluster type list.
     */
    @JvmName("fmmyavspwhooldhn")
    public suspend fun clusterTypeLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterTypeLists = mapped
    }

    /**
     * @param values The cluster type list.
     */
    @JvmName("qbcbavonnxqedpcj")
    public suspend fun clusterTypeLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterTypeLists = mapped
    }

    /**
     * @param value How to create a cluster. Valid values: `ON-DEMAND`, `MANUAL`.
     */
    @JvmName("tlkvlgmktpufkqhr")
    public suspend fun createType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.createType = mapped
    }

    /**
     * @param value The default status.
     */
    @JvmName("fmhmrosogjcatpox")
    public suspend fun defaultStatus(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.defaultStatus = mapped
    }

    /**
     * @param value The hosting type of the cluster. Valid values: `HALF_MANAGED`, `MANAGED`.
     */
    @JvmName("rhwjtdtddpdiljcb")
    public suspend fun depositType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.depositType = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("xwdrbfltgbwjxuur")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Cluster IDs.
     */
    @JvmName("osmitklwjtxubupv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Cluster IDs.
     */
    @JvmName("branmdjvpvfqdpag")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The is desc.
     */
    @JvmName("cucsvrmnadegsjuw")
    public suspend fun isDesc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isDesc = mapped
    }

    /**
     * @param value The host type of the cluster. The default is ECS. Valid values: `DOCKER`, `ECS`, `PYHSICAL_MACHINE`, `ECS_FROM_ECM_HOSTPOOL`.
     */
    @JvmName("yvskastiukshohui")
    public suspend fun machineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.machineType = mapped
    }

    /**
     * @param value A regex string to filter results by Cluster name.
     */
    @JvmName("gvuxdsaliomckfjt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("enkasnlsyibteasi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("htanwyrgspqliyyn")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("kmrfmhkafugcimyq")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The Resource Group ID.
     */
    @JvmName("rqmqxmsfgoydyqhc")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status list. Valid values: `ABNORMAL`, `CREATE_FAILED`, `CREATING`, `IDLE`, `RELEASED`, `RELEASE_FAILED`, `RELEASING`, `RUNNING`, `WAIT_FOR_PAY`.
     */
    @JvmName("sghsmobjuchgwmbd")
    public suspend fun statusLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statusLists = mapped
    }

    /**
     * @param values The status list. Valid values: `ABNORMAL`, `CREATE_FAILED`, `CREATING`, `IDLE`, `RELEASED`, `RELEASE_FAILED`, `RELEASING`, `RUNNING`, `WAIT_FOR_PAY`.
     */
    @JvmName("svbvnnmqnocrancp")
    public suspend fun statusLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statusLists = mapped
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("bnunpwgqjwcjjbaw")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetClustersPlainArgs = GetClustersPlainArgs(
        clusterName = clusterName,
        clusterTypeLists = clusterTypeLists,
        createType = createType,
        defaultStatus = defaultStatus,
        depositType = depositType,
        enableDetails = enableDetails,
        ids = ids,
        isDesc = isDesc,
        machineType = machineType,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        resourceGroupId = resourceGroupId,
        statusLists = statusLists,
        vpcId = vpcId,
    )
}
