@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.GetDiskTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDiskTypes.
 * @property clusterType The cluster type of the emr cluster instance. Possible values: `HADOOP`, `KAFKA`, `ZOOKEEPER`, `DRUID`.
 * @property destinationResource The destination resource of emr cluster instance
 * @property instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
 * @property instanceType The ecs instance type of create emr cluster instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property zoneId The Zone to create emr cluster instance.
 */
public data class GetDiskTypesPlainArgs(
    public val clusterType: String,
    public val destinationResource: String,
    public val instanceChargeType: String,
    public val instanceType: String,
    public val outputFile: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.GetDiskTypesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.GetDiskTypesPlainArgs =
        com.pulumi.alicloud.emr.inputs.GetDiskTypesPlainArgs.builder()
            .clusterType(clusterType.let({ args0 -> args0 }))
            .destinationResource(destinationResource.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType.let({ args0 -> args0 }))
            .instanceType(instanceType.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskTypesPlainArgs].
 */
@PulumiTagMarker
public class GetDiskTypesPlainArgsBuilder internal constructor() {
    private var clusterType: String? = null

    private var destinationResource: String? = null

    private var instanceChargeType: String? = null

    private var instanceType: String? = null

    private var outputFile: String? = null

    private var zoneId: String? = null

    /**
     * @param value The cluster type of the emr cluster instance. Possible values: `HADOOP`, `KAFKA`, `ZOOKEEPER`, `DRUID`.
     */
    @JvmName("meyovohbvlwtfpgu")
    public suspend fun clusterType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterType = mapped
    }

    /**
     * @param value The destination resource of emr cluster instance
     */
    @JvmName("gqslpdkroapnflkm")
    public suspend fun destinationResource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.destinationResource = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     */
    @JvmName("vvbxksjhqgouoqfa")
    public suspend fun instanceChargeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value The ecs instance type of create emr cluster instance.
     */
    @JvmName("fnyucwujialjflep")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gpkiiuxsjvtipxfb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Zone to create emr cluster instance.
     */
    @JvmName("fpqelidovfsirjnr")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetDiskTypesPlainArgs = GetDiskTypesPlainArgs(
        clusterType = clusterType ?: throw PulumiNullFieldException("clusterType"),
        destinationResource = destinationResource ?: throw PulumiNullFieldException("destinationResource"),
        instanceChargeType = instanceChargeType ?: throw PulumiNullFieldException("instanceChargeType"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        outputFile = outputFile,
        zoneId = zoneId,
    )
}
