@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.GetInstanceTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceTypes.
 * @property clusterType The cluster type of the emr cluster instance. Possible values: `HADOOP`, `KAFKA`, `ZOOKEEPER`, `DRUID`.
 * @property destinationResource The destination resource of emr cluster instance
 * @property instanceChargeType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
 * @property instanceType Filter the specific ecs instance type to create emr cluster.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property supportLocalStorage Whether the current storage disk is local or not.
 * @property supportNodeTypes The specific supported node type list.
 * Possible values may be any one or combination of these: ["MASTER", "CORE", "TASK", "GATEWAY"]
 * @property zoneId The supported resources of specific zoneId.
 */
public data class GetInstanceTypesPlainArgs(
    public val clusterType: String,
    public val destinationResource: String,
    public val instanceChargeType: String,
    public val instanceType: String? = null,
    public val outputFile: String? = null,
    public val supportLocalStorage: Boolean? = null,
    public val supportNodeTypes: List<String>? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.GetInstanceTypesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.GetInstanceTypesPlainArgs =
        com.pulumi.alicloud.emr.inputs.GetInstanceTypesPlainArgs.builder()
            .clusterType(clusterType.let({ args0 -> args0 }))
            .destinationResource(destinationResource.let({ args0 -> args0 }))
            .instanceChargeType(instanceChargeType.let({ args0 -> args0 }))
            .instanceType(instanceType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .supportLocalStorage(supportLocalStorage?.let({ args0 -> args0 }))
            .supportNodeTypes(supportNodeTypes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceTypesPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceTypesPlainArgsBuilder internal constructor() {
    private var clusterType: String? = null

    private var destinationResource: String? = null

    private var instanceChargeType: String? = null

    private var instanceType: String? = null

    private var outputFile: String? = null

    private var supportLocalStorage: Boolean? = null

    private var supportNodeTypes: List<String>? = null

    private var zoneId: String? = null

    /**
     * @param value The cluster type of the emr cluster instance. Possible values: `HADOOP`, `KAFKA`, `ZOOKEEPER`, `DRUID`.
     */
    @JvmName("tkufnvebjomfyero")
    public suspend fun clusterType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterType = mapped
    }

    /**
     * @param value The destination resource of emr cluster instance
     */
    @JvmName("hkihhohftrragowm")
    public suspend fun destinationResource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.destinationResource = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`. Default to `PostPaid`.
     */
    @JvmName("wlyvvwupbxchlbwn")
    public suspend fun instanceChargeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceChargeType = mapped
    }

    /**
     * @param value Filter the specific ecs instance type to create emr cluster.
     */
    @JvmName("raigntyipvvfbrng")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("atpadbklrhjtschl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Whether the current storage disk is local or not.
     */
    @JvmName("dkjmuedyqnqtacwr")
    public suspend fun supportLocalStorage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportLocalStorage = mapped
    }

    /**
     * @param value The specific supported node type list.
     * Possible values may be any one or combination of these: ["MASTER", "CORE", "TASK", "GATEWAY"]
     */
    @JvmName("gwjhuojwfbdrynnr")
    public suspend fun supportNodeTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportNodeTypes = mapped
    }

    /**
     * @param values The specific supported node type list.
     * Possible values may be any one or combination of these: ["MASTER", "CORE", "TASK", "GATEWAY"]
     */
    @JvmName("suwlnwdgtnsonqao")
    public suspend fun supportNodeTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportNodeTypes = mapped
    }

    /**
     * @param value The supported resources of specific zoneId.
     */
    @JvmName("kainfwdjwmamvjkf")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetInstanceTypesPlainArgs = GetInstanceTypesPlainArgs(
        clusterType = clusterType ?: throw PulumiNullFieldException("clusterType"),
        destinationResource = destinationResource ?: throw PulumiNullFieldException("destinationResource"),
        instanceChargeType = instanceChargeType ?: throw PulumiNullFieldException("instanceChargeType"),
        instanceType = instanceType,
        outputFile = outputFile,
        supportLocalStorage = supportLocalStorage,
        supportNodeTypes = supportNodeTypes,
        zoneId = zoneId,
    )
}
