@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.inputs

import com.pulumi.alicloud.emr.inputs.GetMainVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMainVersions.
 * @property clusterTypes The supported clusterType of this emr version.
 * Possible values may be any one or combination of these: ["HADOOP", "DRUID", "KAFKA", "ZOOKEEPER", "FLINK", "CLICKHOUSE"]
 * @property emrVersion The version of the emr cluster instance. Possible values: `EMR-4.0.0`, `EMR-3.23.0`, `EMR-3.22.0`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetMainVersionsPlainArgs(
    public val clusterTypes: List<String>? = null,
    public val emrVersion: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emr.inputs.GetMainVersionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.emr.inputs.GetMainVersionsPlainArgs =
        com.pulumi.alicloud.emr.inputs.GetMainVersionsPlainArgs.builder()
            .clusterTypes(clusterTypes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .emrVersion(emrVersion?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMainVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetMainVersionsPlainArgsBuilder internal constructor() {
    private var clusterTypes: List<String>? = null

    private var emrVersion: String? = null

    private var outputFile: String? = null

    /**
     * @param value The supported clusterType of this emr version.
     * Possible values may be any one or combination of these: ["HADOOP", "DRUID", "KAFKA", "ZOOKEEPER", "FLINK", "CLICKHOUSE"]
     */
    @JvmName("oaxqmldfgywhsqcv")
    public suspend fun clusterTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterTypes = mapped
    }

    /**
     * @param values The supported clusterType of this emr version.
     * Possible values may be any one or combination of these: ["HADOOP", "DRUID", "KAFKA", "ZOOKEEPER", "FLINK", "CLICKHOUSE"]
     */
    @JvmName("cwlblgcbxxdlrasp")
    public suspend fun clusterTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterTypes = mapped
    }

    /**
     * @param value The version of the emr cluster instance. Possible values: `EMR-4.0.0`, `EMR-3.23.0`, `EMR-3.22.0`.
     */
    @JvmName("jgouafkbehtinkhx")
    public suspend fun emrVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.emrVersion = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tycvkkpdqhnbbtbj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetMainVersionsPlainArgs = GetMainVersionsPlainArgs(
        clusterTypes = clusterTypes,
        emrVersion = emrVersion,
        outputFile = outputFile,
    )
}
