@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arg bootstrap action args, e.g. "--a=b".
 * @property executionFailStrategy bootstrap action execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ . Default value: "FAILED_BLOCKED
 * @property executionMoment bootstrap action execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ . Default value: "BEFORE_INSTALL".
 * @property executionTarget bootstrap action execution target, you can specify the host group name, e.g. "core_group". If this is not specified, the bootstrap action execution target is whole cluster.
 * @property name The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
 * @property path bootstrap action path, e.g. "oss://bucket/path".
 */
public data class ClusterBootstrapAction(
    public val arg: String? = null,
    public val executionFailStrategy: String? = null,
    public val executionMoment: String? = null,
    public val executionTarget: String? = null,
    public val name: String? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.ClusterBootstrapAction): ClusterBootstrapAction = ClusterBootstrapAction(
            arg = javaType.arg().map({ args0 -> args0 }).orElse(null),
            executionFailStrategy = javaType.executionFailStrategy().map({ args0 -> args0 }).orElse(null),
            executionMoment = javaType.executionMoment().map({ args0 -> args0 }).orElse(null),
            executionTarget = javaType.executionTarget().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
