@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configKey Custom configuration service config key, e.g. ’dfs.replication’.
 * @property configValue Custom configuration service config value, e.g. ’3’.
 * @property fileName Custom configuration service file name, e.g. ’hdfs-site’.
 * @property serviceName
 */
public data class ClusterConfig(
    public val configKey: String,
    public val configValue: String,
    public val fileName: String,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.ClusterConfig): ClusterConfig =
            ClusterConfig(
                configKey = javaType.configKey(),
                configValue = javaType.configValue(),
                fileName = javaType.fileName(),
                serviceName = javaType.serviceName(),
            )
    }
}
