@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoRenew Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
 * @property chargeType Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
 * @property decommissionTimeout Graceful decommission timeout, unit: seconds.
 * @property diskCapacity Data disk capacity.
 * @property diskCount Data disk count.
 * @property diskType Data disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,local_disk,cloud_essd.
 * @property enableGracefulDecommission Enable hadoop cluster of task node graceful decommission, ’true’ or ‘false’ . Default value: false.
 * @property gpuDriver
 * @property hostGroupName host group name.
 * @property hostGroupType host group type, supported value: MASTER, CORE or TASK, supported 'GATEWAY' available in 1.61.0+.
 * @property instanceList Instance list for cluster scale down. This value follows the json format, e.g. ["instance_id1","instance_id2"]. escape character for " is \".
 * @property instanceType Host Ecs instance type.
 * @property nodeCount Host number in this group.
 * @property period If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
 * @property sysDiskCapacity System disk capacity.
 * @property sysDiskType System disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,cloud_essd.
 */
public data class ClusterHostGroup(
    public val autoRenew: Boolean? = null,
    public val chargeType: String? = null,
    public val decommissionTimeout: Int? = null,
    public val diskCapacity: String? = null,
    public val diskCount: String? = null,
    public val diskType: String? = null,
    public val enableGracefulDecommission: Boolean? = null,
    public val gpuDriver: String? = null,
    public val hostGroupName: String? = null,
    public val hostGroupType: String? = null,
    public val instanceList: String? = null,
    public val instanceType: String? = null,
    public val nodeCount: String? = null,
    public val period: Int? = null,
    public val sysDiskCapacity: String? = null,
    public val sysDiskType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.ClusterHostGroup): ClusterHostGroup = ClusterHostGroup(
            autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
            chargeType = javaType.chargeType().map({ args0 -> args0 }).orElse(null),
            decommissionTimeout = javaType.decommissionTimeout().map({ args0 -> args0 }).orElse(null),
            diskCapacity = javaType.diskCapacity().map({ args0 -> args0 }).orElse(null),
            diskCount = javaType.diskCount().map({ args0 -> args0 }).orElse(null),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            enableGracefulDecommission = javaType.enableGracefulDecommission().map({ args0 ->
                args0
            }).orElse(null),
            gpuDriver = javaType.gpuDriver().map({ args0 -> args0 }).orElse(null),
            hostGroupName = javaType.hostGroupName().map({ args0 -> args0 }).orElse(null),
            hostGroupType = javaType.hostGroupType().map({ args0 -> args0 }).orElse(null),
            instanceList = javaType.instanceList().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            nodeCount = javaType.nodeCount().map({ args0 -> args0 }).orElse(null),
            period = javaType.period().map({ args0 -> args0 }).orElse(null),
            sysDiskCapacity = javaType.sysDiskCapacity().map({ args0 -> args0 }).orElse(null),
            sysDiskType = javaType.sysDiskType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
