@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dbPassword Custom rds database password.
 * @property dbUrl Custom rds database connection url.
 * @property dbUserName Custom rds database user name.
 */
public data class ClusterMetaStoreConf(
    public val dbPassword: String,
    public val dbUrl: String,
    public val dbUserName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.ClusterMetaStoreConf): ClusterMetaStoreConf = ClusterMetaStoreConf(
            dbPassword = javaType.dbPassword(),
            dbUrl = javaType.dbUrl(),
            dbUserName = javaType.dbUserName(),
        )
    }
}
