@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comment Cluster service configuration modification comment, e.g. "Modify tez configuration".
 * @property configParams Cluster service configuration modification params, e.g. ’{"hdfs-site":{"dfs.replication":"3"}}’.
 * @property configType Cluster service configuration modification type.
 * @property customConfigParams Cluster service configuration modification custom params, e.g. ’{"tez-site":{"key":{"Value":"value"}}}’.
 * @property gatewayClusterIdLists Cluster service configuration modification related gateway cluster id list.
 * @property groupId Cluster service configuration modification node group id, e.g. ’G-XXX’.
 * @property hostInstanceId Cluster service configuration modification host instance id, e.g. ’i-bp146tnrkq4tcxxxxx’.
 * @property refreshHostConfig Cluster service configuration modification refresh host config, ’true’ or ’false’.
 * @property serviceName
 */
public data class ClusterModifyClusterServiceConfig(
    public val comment: String? = null,
    public val configParams: String,
    public val configType: String? = null,
    public val customConfigParams: String? = null,
    public val gatewayClusterIdLists: List<String>? = null,
    public val groupId: String? = null,
    public val hostInstanceId: String? = null,
    public val refreshHostConfig: Boolean? = null,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.ClusterModifyClusterServiceConfig): ClusterModifyClusterServiceConfig = ClusterModifyClusterServiceConfig(
            comment = javaType.comment().map({ args0 -> args0 }).orElse(null),
            configParams = javaType.configParams(),
            configType = javaType.configType().map({ args0 -> args0 }).orElse(null),
            customConfigParams = javaType.customConfigParams().map({ args0 -> args0 }).orElse(null),
            gatewayClusterIdLists = javaType.gatewayClusterIdLists().map({ args0 -> args0 }),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            hostInstanceId = javaType.hostInstanceId().map({ args0 -> args0 }).orElse(null),
            refreshHostConfig = javaType.refreshHostConfig().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName(),
        )
    }
}
