@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property accessInfos Cluster connection information.
 * @property autoScalingAllowed Whether flexible expansion is allowed.
 * @property autoScalingByLoadAllowed Whether to allow expansion by load.
 * @property autoScalingEnable Whether to enable elastic expansion.
 * @property autoScalingSpotWithLimitAllowed Whether to allow the use of elastic scaling bidding instances.
 * @property bootstrapActionLists List of boot actions.
 * @property bootstrapFailed The result of the boot operation.
 * @property clusterId The first ID of the resource.
 * @property clusterName The ClusterName.
 * @property createResource Cluster tag, no need to pay attention.
 * @property createTime The creation time of the resource.
 * @property createType How to create a cluster.
 * @property depositType The hosting type of the cluster.
 * @property easEnable High security cluster.
 * @property expiredTime The expiration time of the cluster.
 * @property extraInfo Additional information for Stack.
 * @property hasUncompletedOrder
 * @property highAvailabilityEnable High availability cluster.
 * @property hostGroupLists List of cluster machine groups.
 * @property hostPoolInfos Machine pool information.
 * @property id
 * @property imageId The ID of the image used to create the cluster.
 * @property localMetaDb Whether to use Hive local Metabase.
 * @property machineType The host type of the cluster. The default is ECS.
 * @property metaStoreType Metadata type:
 * @property netType Cluster network type.
 * @property paymentType The payment type of the resource.
 * @property period The package year and month time of the machine group. The Valid Values : `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`.
 * @property relateClusterInfos The information of the primary cluster associated with the Gateway.
 * @property resizeDiskEnable Whether to allow disk expansion:
 * @property runningTime The time (in seconds) that has been running.
 * @property securityGroupId The ID of the security group.
 * @property securityGroupName The name of the security group.
 * @property softwareInfos Service list.
 * @property startTime Cluster startup time.
 * @property status The cluster status.
 * @property stopTime Cluster stop time.
 * @property tags A mapping of tags to assign to the resource.
 * @property type Disk type.
 * @property userDefinedEmrEcsRole The EMR permission name used.
 * @property userId The user ID.
 * @property vpcId The VPC ID.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID.
 */
public data class GetClustersCluster(
    public val accessInfos: List<GetClustersClusterAccessInfo>,
    public val autoScalingAllowed: Boolean,
    public val autoScalingByLoadAllowed: Boolean,
    public val autoScalingEnable: Boolean,
    public val autoScalingSpotWithLimitAllowed: Boolean,
    public val bootstrapActionLists: List<GetClustersClusterBootstrapActionList>,
    public val bootstrapFailed: Boolean,
    public val clusterId: String,
    public val clusterName: String,
    public val createResource: String,
    public val createTime: String,
    public val createType: String,
    public val depositType: String,
    public val easEnable: Boolean,
    public val expiredTime: String,
    public val extraInfo: String,
    public val hasUncompletedOrder: Boolean,
    public val highAvailabilityEnable: Boolean,
    public val hostGroupLists: List<GetClustersClusterHostGroupList>,
    public val hostPoolInfos: List<GetClustersClusterHostPoolInfo>,
    public val id: String,
    public val imageId: String,
    public val localMetaDb: Boolean,
    public val machineType: String,
    public val metaStoreType: String,
    public val netType: String,
    public val paymentType: String,
    public val period: Int,
    public val relateClusterInfos: List<GetClustersClusterRelateClusterInfo>,
    public val resizeDiskEnable: Boolean,
    public val runningTime: Int,
    public val securityGroupId: String,
    public val securityGroupName: String,
    public val softwareInfos: List<GetClustersClusterSoftwareInfo>,
    public val startTime: String,
    public val status: String,
    public val stopTime: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val userDefinedEmrEcsRole: String,
    public val userId: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            accessInfos = javaType.accessInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterAccessInfo.Companion.toKotlin(args0)
                })
            }),
            autoScalingAllowed = javaType.autoScalingAllowed(),
            autoScalingByLoadAllowed = javaType.autoScalingByLoadAllowed(),
            autoScalingEnable = javaType.autoScalingEnable(),
            autoScalingSpotWithLimitAllowed = javaType.autoScalingSpotWithLimitAllowed(),
            bootstrapActionLists = javaType.bootstrapActionLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterBootstrapActionList.Companion.toKotlin(args0)
                })
            }),
            bootstrapFailed = javaType.bootstrapFailed(),
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            createResource = javaType.createResource(),
            createTime = javaType.createTime(),
            createType = javaType.createType(),
            depositType = javaType.depositType(),
            easEnable = javaType.easEnable(),
            expiredTime = javaType.expiredTime(),
            extraInfo = javaType.extraInfo(),
            hasUncompletedOrder = javaType.hasUncompletedOrder(),
            highAvailabilityEnable = javaType.highAvailabilityEnable(),
            hostGroupLists = javaType.hostGroupLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterHostGroupList.Companion.toKotlin(args0)
                })
            }),
            hostPoolInfos = javaType.hostPoolInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterHostPoolInfo.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            imageId = javaType.imageId(),
            localMetaDb = javaType.localMetaDb(),
            machineType = javaType.machineType(),
            metaStoreType = javaType.metaStoreType(),
            netType = javaType.netType(),
            paymentType = javaType.paymentType(),
            period = javaType.period(),
            relateClusterInfos = javaType.relateClusterInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterRelateClusterInfo.Companion.toKotlin(args0)
                })
            }),
            resizeDiskEnable = javaType.resizeDiskEnable(),
            runningTime = javaType.runningTime(),
            securityGroupId = javaType.securityGroupId(),
            securityGroupName = javaType.securityGroupName(),
            softwareInfos = javaType.softwareInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterSoftwareInfo.Companion.toKotlin(args0)
                })
            }),
            startTime = javaType.startTime(),
            status = javaType.status(),
            stopTime = javaType.stopTime(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userDefinedEmrEcsRole = javaType.userDefinedEmrEcsRole(),
            userId = javaType.userId(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
