@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandWidth Bandwidth.
 * @property chargeType Payment Type.
 * @property cpuCore The number of CPU cores.
 * @property diskCapacity Data disk capacity.
 * @property diskCount The number of data disks.
 * @property diskType System disk type:
 * @property hostGroupChangeType The current operation type of the machine Group:
 * @property hostGroupId The ID of the machine group.
 * @property hostGroupName The name of the machine group.
 * @property hostGroupType Role of host in cluster:
 * @property instanceType Machine Group instance.
 * @property memoryCapacity Memory size.
 * @property nodeCount The number of machine group nodes.
 * @property nodes Machine node.
 * @property period Package year and month time (days).
 */
public data class GetClustersClusterHostGroupList(
    public val bandWidth: String,
    public val chargeType: String,
    public val cpuCore: Int,
    public val diskCapacity: Int,
    public val diskCount: Int,
    public val diskType: String,
    public val hostGroupChangeType: String,
    public val hostGroupId: String,
    public val hostGroupName: String,
    public val hostGroupType: String,
    public val instanceType: String,
    public val memoryCapacity: Int,
    public val nodeCount: Int,
    public val nodes: List<GetClustersClusterHostGroupListNode>,
    public val period: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetClustersClusterHostGroupList): GetClustersClusterHostGroupList = GetClustersClusterHostGroupList(
            bandWidth = javaType.bandWidth(),
            chargeType = javaType.chargeType(),
            cpuCore = javaType.cpuCore(),
            diskCapacity = javaType.diskCapacity(),
            diskCount = javaType.diskCount(),
            diskType = javaType.diskType(),
            hostGroupChangeType = javaType.hostGroupChangeType(),
            hostGroupId = javaType.hostGroupId(),
            hostGroupName = javaType.hostGroupName(),
            hostGroupType = javaType.hostGroupType(),
            instanceType = javaType.instanceType(),
            memoryCapacity = javaType.memoryCapacity(),
            nodeCount = javaType.nodeCount(),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterHostGroupListNode.Companion.toKotlin(args0)
                })
            }),
            period = javaType.period(),
        )
    }
}
