@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime Creation time.
 * @property diskInfos Disk information.
 * @property emrExpiredTime The timeout of the EMR.
 * @property expiredTime Timeout time.
 * @property innerIp The Intranet IP of the EMR.
 * @property instanceId The ID of the ECS instance.
 * @property pubIp Public IP address.
 * @property status Status.
 * @property supportIpv6 Whether IPV6 is supported.
 * @property zoneId The zone ID.
 */
public data class GetClustersClusterHostGroupListNode(
    public val createTime: String,
    public val diskInfos: List<GetClustersClusterHostGroupListNodeDiskInfo>,
    public val emrExpiredTime: String,
    public val expiredTime: String,
    public val innerIp: String,
    public val instanceId: String,
    public val pubIp: String,
    public val status: String,
    public val supportIpv6: Boolean,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetClustersClusterHostGroupListNode): GetClustersClusterHostGroupListNode = GetClustersClusterHostGroupListNode(
            createTime = javaType.createTime(),
            diskInfos = javaType.diskInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterHostGroupListNodeDiskInfo.Companion.toKotlin(args0)
                })
            }),
            emrExpiredTime = javaType.emrExpiredTime(),
            expiredTime = javaType.expiredTime(),
            innerIp = javaType.innerIp(),
            instanceId = javaType.instanceId(),
            pubIp = javaType.pubIp(),
            status = javaType.status(),
            supportIpv6 = javaType.supportIpv6(),
            zoneId = javaType.zoneId(),
        )
    }
}
