@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusterType Cluster type:
 * @property emrVer E-MapReduce version number.
 * @property softwares Service list.
 */
public data class GetClustersClusterSoftwareInfo(
    public val clusterType: String,
    public val emrVer: String,
    public val softwares: List<GetClustersClusterSoftwareInfoSoftware>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetClustersClusterSoftwareInfo): GetClustersClusterSoftwareInfo = GetClustersClusterSoftwareInfo(
            clusterType = javaType.clusterType(),
            emrVer = javaType.emrVer(),
            softwares = javaType.softwares().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersClusterSoftwareInfoSoftware.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
