@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getClusters.
 * @property clusterName
 * @property clusterTypeLists
 * @property clusters
 * @property createType
 * @property defaultStatus
 * @property depositType
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property isDesc
 * @property machineType
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId
 * @property statusLists
 * @property totalCount
 * @property vpcId
 */
public data class GetClustersResult(
    public val clusterName: String? = null,
    public val clusterTypeLists: List<String>? = null,
    public val clusters: List<GetClustersCluster>,
    public val createType: String? = null,
    public val defaultStatus: Boolean? = null,
    public val depositType: String? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val isDesc: Boolean? = null,
    public val machineType: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val statusLists: List<String>? = null,
    public val totalCount: Int,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetClustersResult): GetClustersResult = GetClustersResult(
            clusterName = javaType.clusterName().map({ args0 -> args0 }).orElse(null),
            clusterTypeLists = javaType.clusterTypeLists().map({ args0 -> args0 }),
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetClustersCluster.Companion.toKotlin(args0)
                })
            }),
            createType = javaType.createType().map({ args0 -> args0 }).orElse(null),
            defaultStatus = javaType.defaultStatus().map({ args0 -> args0 }).orElse(null),
            depositType = javaType.depositType().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            isDesc = javaType.isDesc().map({ args0 -> args0 }).orElse(null),
            machineType = javaType.machineType().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            statusLists = javaType.statusLists().map({ args0 -> args0 }),
            totalCount = javaType.totalCount(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
