@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDiskTypes.
 * @property clusterType
 * @property destinationResource
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of data disk and system disk type IDs.
 * @property instanceChargeType
 * @property instanceType
 * @property outputFile
 * @property types A list of emr instance types. Each element contains the following attributes:
 * @property zoneId
 */
public data class GetDiskTypesResult(
    public val clusterType: String,
    public val destinationResource: String,
    public val id: String,
    public val ids: List<String>,
    public val instanceChargeType: String,
    public val instanceType: String,
    public val outputFile: String? = null,
    public val types: List<GetDiskTypesType>,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetDiskTypesResult): GetDiskTypesResult = GetDiskTypesResult(
            clusterType = javaType.clusterType(),
            destinationResource = javaType.destinationResource(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceChargeType = javaType.instanceChargeType(),
            instanceType = javaType.instanceType(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            types = javaType.types().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetDiskTypesType.Companion.toKotlin(args0)
                })
            }),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
