@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the instance type.
 * @property localStorageCapacity Local capacity of the applied ecs instance for emr cluster. Unit: GB.
 * @property zoneId The supported resources of specific zoneId.
 */
public data class GetInstanceTypesType(
    public val id: String,
    public val localStorageCapacity: Int,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetInstanceTypesType): GetInstanceTypesType = GetInstanceTypesType(
            id = javaType.id(),
            localStorageCapacity = javaType.localStorageCapacity(),
            zoneId = javaType.zoneId(),
        )
    }
}
