@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusterTypes A list of cluster types the emr cluster supported. Possible values: `HADOOP`, `ZOOKEEPER`, `KAFKA`, `DRUID`.
 * @property emrVersion The version of the emr cluster instance. Possible values: `EMR-4.0.0`, `EMR-3.23.0`, `EMR-3.22.0`.
 * @property imageId The image id of the emr cluster instance.
 */
public data class GetMainVersionsMainVersion(
    public val clusterTypes: List<String>,
    public val emrVersion: String,
    public val imageId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetMainVersionsMainVersion): GetMainVersionsMainVersion = GetMainVersionsMainVersion(
            clusterTypes = javaType.clusterTypes().map({ args0 -> args0 }),
            emrVersion = javaType.emrVersion(),
            imageId = javaType.imageId(),
        )
    }
}
