@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMainVersions.
 * @property clusterTypes
 * @property emrVersion The version of the emr cluster instance.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of emr instance types IDs.
 * @property mainVersions A list of versions of the emr cluster instance. Each element contains the following attributes:
 * @property outputFile
 */
public data class GetMainVersionsResult(
    public val clusterTypes: List<String>? = null,
    public val emrVersion: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val mainVersions: List<GetMainVersionsMainVersion>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emr.outputs.GetMainVersionsResult): GetMainVersionsResult = GetMainVersionsResult(
            clusterTypes = javaType.clusterTypes().map({ args0 -> args0 }),
            emrVersion = javaType.emrVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            mainVersions = javaType.mainVersions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emr.kotlin.outputs.GetMainVersionsMainVersion.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
