@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin

import com.pulumi.alicloud.emrv2.ClusterArgs.builder
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterApplicationConfigArgs
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterApplicationConfigArgsBuilder
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterBootstrapScriptArgs
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterBootstrapScriptArgsBuilder
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterNodeAttributeArgs
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterNodeAttributeArgsBuilder
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterNodeGroupArgs
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterNodeGroupArgsBuilder
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterSubscriptionConfigArgs
import com.pulumi.alicloud.emrv2.kotlin.inputs.ClusterSubscriptionConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a EMR cluster resource. This resource is based on EMR's new version OpenAPI.
 * For information about EMR New and how to use it, see [Add a domain](https://www.alibabacloud.com/help/doc-detail/28068.htm).
 * > **NOTE:** Available since v1.199.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultGetKeys = alicloud.kms.getKeys({
 *     status: "Enabled",
 * });
 * const defaultGetZones = alicloud.getZones({
 *     availableInstanceType: "ecs.g7.xlarge",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultEcsKeyPair = new alicloud.ecs.EcsKeyPair("default", {keyPairName: `${name}-${defaultInteger.result}`});
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultRole = new alicloud.ram.Role("default", {
 *     name: name,
 *     document: `    {
 *         "Statement": [
 *         {
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Principal": {
 *             "Service": [
 *                 "emr.aliyuncs.com",
 *                 "ecs.aliyuncs.com"
 *             ]
 *             }
 *         }
 *         ],
 *         "Version": "1"
 *     }
 * `,
 *     description: "this is a role example.",
 *     force: true,
 * });
 * const defaultCluster = new alicloud.emrv2.Cluster("default", {
 *     nodeGroups: [
 *         {
 *             vswitchIds: [defaultSwitch&#46;id],
 *             instanceTypes: ["ecs&#46;g7&#46;xlarge"],
 *             nodeCount: 1,
 *             spotInstanceRemedy: false,
 *             dataDisks: [{
 *                 count: 3,
 *                 category: "cloud_essd",
 *                 size: 80,
 *                 performanceLevel: "PL0",
 *             }],
 *             nodeGroupName: "emr-master",
 *             paymentType: "PayAsYouGo",
 *             withPublicIp: false,
 *             gracefulShutdown: false,
 *             systemDisk: {
 *                 category: "cloud_essd",
 *                 size: 80,
 *                 performanceLevel: "PL0",
 *                 count: 1,
 *             },
 *             nodeGroupType: "MASTER",
 *         },
 *         {
 *             spotInstanceRemedy: false,
 *             nodeGroupType: "CORE",
 *             vswitchIds: [defaultSwitch&#46;id],
 *             nodeCount: 2,
 *             gracefulShutdown: false,
 *             systemDisk: {
 *                 performanceLevel: "PL0",
 *                 count: 1,
 *                 category: "cloud_essd",
 *                 size: 80,
 *             },
 *             dataDisks: [{
 *                 count: 3,
 *                 performanceLevel: "PL0",
 *                 category: "cloud_essd",
 *                 size: 80,
 *             }],
 *             nodeGroupName: "emr-core",
 *             paymentType: "PayAsYouGo",
 *             instanceTypes: ["ecs&#46;g7&#46;xlarge"],
 *             withPublicIp: false,
 *         },
 *     ],
 *     deployMode: "NORMAL",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     releaseVersion: "EMR-5.10.0",
 *     applications: [
 *         "HADOOP-COMMON",
 *         "HDFS",
 *         "YARN",
 *     ],
 *     nodeAttributes: [{
 *         zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *         keyPairName: defaultEcsKeyPair.id,
 *         dataDiskEncrypted: true,
 *         dataDiskKmsKeyId: defaultGetKeys.then(defaultGetKeys => defaultGetKeys.ids?.[0]),
 *         vpcId: defaultNetwork.id,
 *         ramRole: defaultRole.name,
 *         securityGroupId: defaultSecurityGroup.id,
 *     }],
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     clusterName: name,
 *     paymentType: "PayAsYouGo",
 *     clusterType: "DATAFLOW",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_get_keys = alicloud.kms.get_keys(status="Enabled")
 * default_get_zones = alicloud.get_zones(available_instance_type="ecs.g7.xlarge")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=default_get_zones.zones[0].id,
 *     vswitch_name=name)
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_ecs_key_pair = alicloud.ecs.EcsKeyPair("default", key_pair_name=f"{name}-{default_integer['result']}")
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_role = alicloud.ram.Role("default",
 *     name=name,
 *     document="""    {
 *         "Statement": [
 *         {
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Principal": {
 *             "Service": [
 *                 "emr.aliyuncs.com",
 *                 "ecs.aliyuncs.com"
 *             ]
 *             }
 *         }
 *         ],
 *         "Version": "1"
 *     }
 * """,
 *     description="this is a role example.",
 *     force=True)
 * default_cluster = alicloud.emrv2.Cluster("default",
 *     node_groups=[
 *         {
 *             "vswitch_ids": [default_switch&#46;id],
 *             "instance_types": ["ecs&#46;g7&#46;xlarge"],
 *             "node_count": 1,
 *             "spot_instance_remedy": False,
 *             "data_disks": [{
 *                 "count": 3,
 *                 "category": "cloud_essd",
 *                 "size": 80,
 *                 "performance_level": "PL0",
 *             }],
 *             "node_group_name": "emr-master",
 *             "payment_type": "PayAsYouGo",
 *             "with_public_ip": False,
 *             "graceful_shutdown": False,
 *             "system_disk": {
 *                 "category": "cloud_essd",
 *                 "size": 80,
 *                 "performance_level": "PL0",
 *                 "count": 1,
 *             },
 *             "node_group_type": "MASTER",
 *         },
 *         {
 *             "spot_instance_remedy": False,
 *             "node_group_type": "CORE",
 *             "vswitch_ids": [default_switch&#46;id],
 *             "node_count": 2,
 *             "graceful_shutdown": False,
 *             "system_disk": {
 *                 "performance_level": "PL0",
 *                 "count": 1,
 *                 "category": "cloud_essd",
 *                 "size": 80,
 *             },
 *             "data_disks": [{
 *                 "count": 3,
 *                 "performance_level": "PL0",
 *                 "category": "cloud_essd",
 *                 "size": 80,
 *             }],
 *             "node_group_name": "emr-core",
 *             "payment_type": "PayAsYouGo",
 *             "instance_types": ["ecs&#46;g7&#46;xlarge"],
 *             "with_public_ip": False,
 *         },
 *     ],
 *     deploy_mode="NORMAL",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     release_version="EMR-5.10.0",
 *     applications=[
 *         "HADOOP-COMMON",
 *         "HDFS",
 *         "YARN",
 *     ],
 *     node_attributes=[{
 *         "zone_id": default_get_zones.zones[0].id,
 *         "key_pair_name": default_ecs_key_pair.id,
 *         "data_disk_encrypted": True,
 *         "data_disk_kms_key_id": default_get_keys.ids[0],
 *         "vpc_id": default_network.id,
 *         "ram_role": default_role.name,
 *         "security_group_id": default_security_group.id,
 *     }],
 *     resource_group_id=default.ids[0],
 *     cluster_name=name,
 *     payment_type="PayAsYouGo",
 *     cluster_type="DATAFLOW")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultGetKeys = AliCloud.Kms.GetKeys.Invoke(new()
 *     {
 *         Status = "Enabled",
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableInstanceType = "ecs.g7.xlarge",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         VswitchName = name,
 *     });
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultEcsKeyPair = new AliCloud.Ecs.EcsKeyPair("default", new()
 *     {
 *         KeyPairName = $"{name}-{defaultInteger.Result}",
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultRole = new AliCloud.Ram.Role("default", new()
 *     {
 *         Name = name,
 *         Document = @"    {
 *         ""Statement"": [
 *         {
 *             ""Action"": ""sts:AssumeRole"",
 *             ""Effect"": ""Allow"",
 *             ""Principal"": {
 *             ""Service"": [
 *                 ""emr.aliyuncs.com"",
 *                 ""ecs.aliyuncs.com""
 *             ]
 *             }
 *         }
 *         ],
 *         ""Version"": ""1""
 *     }
 * ",
 *         Description = "this is a role example.",
 *         Force = true,
 *     });
 *     var defaultCluster = new AliCloud.Emrv2.Cluster("default", new()
 *     {
 *         NodeGroups = new[]
 *         {
 *             new AliCloud.Emrv2.Inputs.ClusterNodeGroupArgs
 *             {
 *                 VswitchIds = new[]
 *                 {
 *                     defaultSwitch.Id,
 *                 },
 *                 InstanceTypes = new[]
 *                 {
 *                     "ecs.g7.xlarge",
 *                 },
 *                 NodeCount = 1,
 *                 SpotInstanceRemedy = false,
 *                 DataDisks = new[]
 *                 {
 *                     new AliCloud.Emrv2.Inputs.ClusterNodeGroupDataDiskArgs
 *                     {
 *                         Count = 3,
 *                         Category = "cloud_essd",
 *                         Size = 80,
 *                         PerformanceLevel = "PL0",
 *                     },
 *                 },
 *                 NodeGroupName = "emr-master",
 *                 PaymentType = "PayAsYouGo",
 *                 WithPublicIp = false,
 *                 GracefulShutdown = false,
 *                 SystemDisk = new AliCloud.Emrv2.Inputs.ClusterNodeGroupSystemDiskArgs
 *                 {
 *                     Category = "cloud_essd",
 *                     Size = 80,
 *                     PerformanceLevel = "PL0",
 *                     Count = 1,
 *                 },
 *                 NodeGroupType = "MASTER",
 *             },
 *             new AliCloud.Emrv2.Inputs.ClusterNodeGroupArgs
 *             {
 *                 SpotInstanceRemedy = false,
 *                 NodeGroupType = "CORE",
 *                 VswitchIds = new[]
 *                 {
 *                     defaultSwitch.Id,
 *                 },
 *                 NodeCount = 2,
 *                 GracefulShutdown = false,
 *                 SystemDisk = new AliCloud.Emrv2.Inputs.ClusterNodeGroupSystemDiskArgs
 *                 {
 *                     PerformanceLevel = "PL0",
 *                     Count = 1,
 *                     Category = "cloud_essd",
 *                     Size = 80,
 *                 },
 *                 DataDisks = new[]
 *                 {
 *                     new AliCloud.Emrv2.Inputs.ClusterNodeGroupDataDiskArgs
 *                     {
 *                         Count = 3,
 *                         PerformanceLevel = "PL0",
 *                         Category = "cloud_essd",
 *                         Size = 80,
 *                     },
 *                 },
 *                 NodeGroupName = "emr-core",
 *                 PaymentType = "PayAsYouGo",
 *                 InstanceTypes = new[]
 *                 {
 *                     "ecs.g7.xlarge",
 *                 },
 *                 WithPublicIp = false,
 *             },
 *         },
 *         DeployMode = "NORMAL",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         ReleaseVersion = "EMR-5.10.0",
 *         Applications = new[]
 *         {
 *             "HADOOP-COMMON",
 *             "HDFS",
 *             "YARN",
 *         },
 *         NodeAttributes = new[]
 *         {
 *             new AliCloud.Emrv2.Inputs.ClusterNodeAttributeArgs
 *             {
 *                 ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *                 KeyPairName = defaultEcsKeyPair.Id,
 *                 DataDiskEncrypted = true,
 *                 DataDiskKmsKeyId = defaultGetKeys.Apply(getKeysResult => getKeysResult.Ids[0]),
 *                 VpcId = defaultNetwork.Id,
 *                 RamRole = defaultRole.Name,
 *                 SecurityGroupId = defaultSecurityGroup.Id,
 *             },
 *         },
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         ClusterName = name,
 *         PaymentType = "PayAsYouGo",
 *         ClusterType = "DATAFLOW",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/emrv2"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetKeys, err := kms.GetKeys(ctx, &kms.GetKeysArgs{
 * 			Status: pulumi.StringRef("Enabled"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableInstanceType: pulumi.StringRef("ecs.g7.xlarge"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEcsKeyPair, err := ecs.NewEcsKeyPair(ctx, "default", &ecs.EcsKeyPairArgs{
 * 			KeyPairName: pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRole, err := ram.NewRole(ctx, "default", &ram.RoleArgs{
 * 			Name: pulumi.String(name),
 * 			Document: pulumi.String(`    {
 *         "Statement": [
 *         {
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Principal": {
 *             "Service": [
 *                 "emr.aliyuncs.com",
 *                 "ecs.aliyuncs.com"
 *             ]
 *             }
 *         }
 *         ],
 *         "Version": "1"
 *     }
 * `),
 * 			Description: pulumi.String("this is a role example."),
 * 			Force:       pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = emrv2.NewCluster(ctx, "default", &emrv2.ClusterArgs{
 * 			NodeGroups: emrv2.ClusterNodeGroupArray{
 * 				&emrv2.ClusterNodeGroupArgs{
 * 					VswitchIds: pulumi.StringArray{
 * 						defaultSwitch.ID(),
 * 					},
 * 					InstanceTypes: pulumi.StringArray{
 * 						pulumi.String("ecs.g7.xlarge"),
 * 					},
 * 					NodeCount:          pulumi.Int(1),
 * 					SpotInstanceRemedy: pulumi.Bool(false),
 * 					DataDisks: emrv2.ClusterNodeGroupDataDiskArray{
 * 						&emrv2.ClusterNodeGroupDataDiskArgs{
 * 							Count:            pulumi.Int(3),
 * 							Category:         pulumi.String("cloud_essd"),
 * 							Size:             pulumi.Int(80),
 * 							PerformanceLevel: pulumi.String("PL0"),
 * 						},
 * 					},
 * 					NodeGroupName:    pulumi.String("emr-master"),
 * 					PaymentType:      pulumi.String("PayAsYouGo"),
 * 					WithPublicIp:     pulumi.Bool(false),
 * 					GracefulShutdown: pulumi.Bool(false),
 * 					SystemDisk: &emrv2.ClusterNodeGroupSystemDiskArgs{
 * 						Category:         pulumi.String("cloud_essd"),
 * 						Size:             pulumi.Int(80),
 * 						PerformanceLevel: pulumi.String("PL0"),
 * 						Count:            pulumi.Int(1),
 * 					},
 * 					NodeGroupType: pulumi.String("MASTER"),
 * 				},
 * 				&emrv2.ClusterNodeGroupArgs{
 * 					SpotInstanceRemedy: pulumi.Bool(false),
 * 					NodeGroupType:      pulumi.String("CORE"),
 * 					VswitchIds: pulumi.StringArray{
 * 						defaultSwitch.ID(),
 * 					},
 * 					NodeCount:        pulumi.Int(2),
 * 					GracefulShutdown: pulumi.Bool(false),
 * 					SystemDisk: &emrv2.ClusterNodeGroupSystemDiskArgs{
 * 						PerformanceLevel: pulumi.String("PL0"),
 * 						Count:            pulumi.Int(1),
 * 						Category:         pulumi.String("cloud_essd"),
 * 						Size:             pulumi.Int(80),
 * 					},
 * 					DataDisks: emrv2.ClusterNodeGroupDataDiskArray{
 * 						&emrv2.ClusterNodeGroupDataDiskArgs{
 * 							Count:            pulumi.Int(3),
 * 							PerformanceLevel: pulumi.String("PL0"),
 * 							Category:         pulumi.String("cloud_essd"),
 * 							Size:             pulumi.Int(80),
 * 						},
 * 					},
 * 					NodeGroupName: pulumi.String("emr-core"),
 * 					PaymentType:   pulumi.String("PayAsYouGo"),
 * 					InstanceTypes: pulumi.StringArray{
 * 						pulumi.String("ecs.g7.xlarge"),
 * 					},
 * 					WithPublicIp: pulumi.Bool(false),
 * 				},
 * 			},
 * 			DeployMode: pulumi.String("NORMAL"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			ReleaseVersion: pulumi.String("EMR-5.10.0"),
 * 			Applications: pulumi.StringArray{
 * 				pulumi.String("HADOOP-COMMON"),
 * 				pulumi.String("HDFS"),
 * 				pulumi.String("YARN"),
 * 			},
 * 			NodeAttributes: emrv2.ClusterNodeAttributeArray{
 * 				&emrv2.ClusterNodeAttributeArgs{
 * 					ZoneId:            pulumi.String(defaultGetZones.Zones[0].Id),
 * 					KeyPairName:       defaultEcsKeyPair.ID(),
 * 					DataDiskEncrypted: pulumi.Bool(true),
 * 					DataDiskKmsKeyId:  pulumi.String(defaultGetKeys.Ids[0]),
 * 					VpcId:             defaultNetwork.ID(),
 * 					RamRole:           defaultRole.Name,
 * 					SecurityGroupId:   defaultSecurityGroup.ID(),
 * 				},
 * 			},
 * 			ResourceGroupId: pulumi.String(_default.Ids[0]),
 * 			ClusterName:     pulumi.String(name),
 * 			PaymentType:     pulumi.String("PayAsYouGo"),
 * 			ClusterType:     pulumi.String("DATAFLOW"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.kms.KmsFunctions;
 * import com.pulumi.alicloud.kms.inputs.GetKeysArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.ecs.EcsKeyPair;
 * import com.pulumi.alicloud.ecs.EcsKeyPairArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ram.Role;
 * import com.pulumi.alicloud.ram.RoleArgs;
 * import com.pulumi.alicloud.emrv2.Cluster;
 * import com.pulumi.alicloud.emrv2.ClusterArgs;
 * import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupArgs;
 * import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSystemDiskArgs;
 * import com.pulumi.alicloud.emrv2.inputs.ClusterNodeAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         final var defaultGetKeys = KmsFunctions.getKeys(GetKeysArgs.builder()
 *             .status("Enabled")
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableInstanceType("ecs.g7.xlarge")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .vswitchName(name)
 *             .build());
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultEcsKeyPair = new EcsKeyPair("defaultEcsKeyPair", EcsKeyPairArgs.builder()
 *             .keyPairName(String.format("%s-%s", name,defaultInteger.result()))
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultRole = new Role("defaultRole", RoleArgs.builder()
 *             .name(name)
 *             .document("""
 *     {
 *         "Statement": [
 *         {
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Principal": {
 *             "Service": [
 *                 "emr.aliyuncs.com",
 *                 "ecs.aliyuncs.com"
 *             ]
 *             }
 *         }
 *         ],
 *         "Version": "1"
 *     }
 *             """)
 *             .description("this is a role example.")
 *             .force(true)
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .nodeGroups(
 *                 ClusterNodeGroupArgs.builder()
 *                     .vswitchIds(defaultSwitch.id())
 *                     .instanceTypes("ecs.g7.xlarge")
 *                     .nodeCount("1")
 *                     .spotInstanceRemedy("false")
 *                     .dataDisks(ClusterNodeGroupDataDiskArgs.builder()
 *                         .count("3")
 *                         .category("cloud_essd")
 *                         .size("80")
 *                         .performanceLevel("PL0")
 *                         .build())
 *                     .nodeGroupName("emr-master")
 *                     .paymentType("PayAsYouGo")
 *                     .withPublicIp("false")
 *                     .gracefulShutdown("false")
 *                     .systemDisk(ClusterNodeGroupSystemDiskArgs.builder()
 *                         .category("cloud_essd")
 *                         .size("80")
 *                         .performanceLevel("PL0")
 *                         .count("1")
 *                         .build())
 *                     .nodeGroupType("MASTER")
 *                     .build(),
 *                 ClusterNodeGroupArgs.builder()
 *                     .spotInstanceRemedy("false")
 *                     .nodeGroupType("CORE")
 *                     .vswitchIds(defaultSwitch.id())
 *                     .nodeCount("2")
 *                     .gracefulShutdown("false")
 *                     .systemDisk(ClusterNodeGroupSystemDiskArgs.builder()
 *                         .performanceLevel("PL0")
 *                         .count("1")
 *                         .category("cloud_essd")
 *                         .size("80")
 *                         .build())
 *                     .dataDisks(ClusterNodeGroupDataDiskArgs.builder()
 *                         .count("3")
 *                         .performanceLevel("PL0")
 *                         .category("cloud_essd")
 *                         .size("80")
 *                         .build())
 *                     .nodeGroupName("emr-core")
 *                     .paymentType("PayAsYouGo")
 *                     .instanceTypes("ecs.g7.xlarge")
 *                     .withPublicIp("false")
 *                     .build())
 *             .deployMode("NORMAL")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .releaseVersion("EMR-5.10.0")
 *             .applications(
 *                 "HADOOP-COMMON",
 *                 "HDFS",
 *                 "YARN")
 *             .nodeAttributes(ClusterNodeAttributeArgs.builder()
 *                 .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *                 .keyPairName(defaultEcsKeyPair.id())
 *                 .dataDiskEncrypted("true")
 *                 .dataDiskKmsKeyId(defaultGetKeys.applyValue(getKeysResult -> getKeysResult.ids()[0]))
 *                 .vpcId(defaultNetwork.id())
 *                 .ramRole(defaultRole.name())
 *                 .securityGroupId(defaultSecurityGroup.id())
 *                 .build())
 *             .resourceGroupId(default_.ids()[0])
 *             .clusterName(name)
 *             .paymentType("PayAsYouGo")
 *             .clusterType("DATAFLOW")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${defaultGetZones.zones[0].id}
 *       vswitchName: ${name}
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultEcsKeyPair:
 *     type: alicloud:ecs:EcsKeyPair
 *     name: default
 *     properties:
 *       keyPairName: ${name}-${defaultInteger.result}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultRole:
 *     type: alicloud:ram:Role
 *     name: default
 *     properties:
 *       name: ${name}
 *       document: |2
 *             {
 *                 "Statement": [
 *                 {
 *                     "Action": "sts:AssumeRole",
 *                     "Effect": "Allow",
 *                     "Principal": {
 *                     "Service": [
 *                         "emr.aliyuncs.com",
 *                         "ecs.aliyuncs.com"
 *                     ]
 *                     }
 *                 }
 *                 ],
 *                 "Version": "1"
 *             }
 *       description: this is a role example.
 *       force: true
 *   defaultCluster:
 *     type: alicloud:emrv2:Cluster
 *     name: default
 *     properties:
 *       nodeGroups:
 *         - vswitchIds:
 *             - ${defaultSwitch.id}
 *           instanceTypes:
 *             - ecs.g7.xlarge
 *           nodeCount: '1'
 *           spotInstanceRemedy: 'false'
 *           dataDisks:
 *             - count: '3'
 *               category: cloud_essd
 *               size: '80'
 *               performanceLevel: PL0
 *           nodeGroupName: emr-master
 *           paymentType: PayAsYouGo
 *           withPublicIp: 'false'
 *           gracefulShutdown: 'false'
 *           systemDisk:
 *             category: cloud_essd
 *             size: '80'
 *             performanceLevel: PL0
 *             count: '1'
 *           nodeGroupType: MASTER
 *         - spotInstanceRemedy: 'false'
 *           nodeGroupType: CORE
 *           vswitchIds:
 *             - ${defaultSwitch.id}
 *           nodeCount: '2'
 *           gracefulShutdown: 'false'
 *           systemDisk:
 *             performanceLevel: PL0
 *             count: '1'
 *             category: cloud_essd
 *             size: '80'
 *           dataDisks:
 *             - count: '3'
 *               performanceLevel: PL0
 *               category: cloud_essd
 *               size: '80'
 *           nodeGroupName: emr-core
 *           paymentType: PayAsYouGo
 *           instanceTypes:
 *             - ecs.g7.xlarge
 *           withPublicIp: 'false'
 *       deployMode: NORMAL
 *       tags:
 *         Created: TF
 *         For: example
 *       releaseVersion: EMR-5.10.0
 *       applications:
 *         - HADOOP-COMMON
 *         - HDFS
 *         - YARN
 *       nodeAttributes:
 *         - zoneId: ${defaultGetZones.zones[0].id}
 *           keyPairName: ${defaultEcsKeyPair.id}
 *           dataDiskEncrypted: 'true'
 *           dataDiskKmsKeyId: ${defaultGetKeys.ids[0]}
 *           vpcId: ${defaultNetwork.id}
 *           ramRole: ${defaultRole.name}
 *           securityGroupId: ${defaultSecurityGroup.id}
 *       resourceGroupId: ${default.ids[0]}
 *       clusterName: ${name}
 *       paymentType: PayAsYouGo
 *       clusterType: DATAFLOW
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 *   defaultGetKeys:
 *     fn::invoke:
 *       Function: alicloud:kms:getKeys
 *       Arguments:
 *         status: Enabled
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableInstanceType: ecs.g7.xlarge
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Aliclioud E-MapReduce cluster can be imported using the id e.g.
 * ```sh
 * $ pulumi import alicloud:emrv2/cluster:Cluster default <id>
 * ```
 * @property applicationConfigs The application configurations of EMR cluster. See `application_configs` below.
 * @property applications The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
 * @property bootstrapScripts The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
 * @property clusterName The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
 * @property clusterType EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
 * @property deployMode The deploy mode of EMR cluster. Supported value: NORMAL or HA.
 * @property logCollectStrategy The log collect strategy of EMR cluster.
 * @property nodeAttributes The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
 * @property nodeGroups Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
 * @property paymentType Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
 * @property releaseVersion EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
 * @property resourceGroupId The Id of resource group which the emr-cluster belongs.
 * @property securityMode The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
 * @property subscriptionConfig The detail configuration of subscription payment type. See `subscription_config` below.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class ClusterArgs(
    public val applicationConfigs: Output<List<ClusterApplicationConfigArgs>>? = null,
    public val applications: Output<List<String>>? = null,
    public val bootstrapScripts: Output<List<ClusterBootstrapScriptArgs>>? = null,
    public val clusterName: Output<String>? = null,
    public val clusterType: Output<String>? = null,
    public val deployMode: Output<String>? = null,
    public val logCollectStrategy: Output<String>? = null,
    public val nodeAttributes: Output<List<ClusterNodeAttributeArgs>>? = null,
    public val nodeGroups: Output<List<ClusterNodeGroupArgs>>? = null,
    public val paymentType: Output<String>? = null,
    public val releaseVersion: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityMode: Output<String>? = null,
    public val subscriptionConfig: Output<ClusterSubscriptionConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.ClusterArgs =
        com.pulumi.alicloud.emrv2.ClusterArgs.builder()
            .applicationConfigs(
                applicationConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .applications(applications?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bootstrapScripts(
                bootstrapScripts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterType(clusterType?.applyValue({ args0 -> args0 }))
            .deployMode(deployMode?.applyValue({ args0 -> args0 }))
            .logCollectStrategy(logCollectStrategy?.applyValue({ args0 -> args0 }))
            .nodeAttributes(
                nodeAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nodeGroups(
                nodeGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .releaseVersion(releaseVersion?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityMode(securityMode?.applyValue({ args0 -> args0 }))
            .subscriptionConfig(
                subscriptionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var applicationConfigs: Output<List<ClusterApplicationConfigArgs>>? = null

    private var applications: Output<List<String>>? = null

    private var bootstrapScripts: Output<List<ClusterBootstrapScriptArgs>>? = null

    private var clusterName: Output<String>? = null

    private var clusterType: Output<String>? = null

    private var deployMode: Output<String>? = null

    private var logCollectStrategy: Output<String>? = null

    private var nodeAttributes: Output<List<ClusterNodeAttributeArgs>>? = null

    private var nodeGroups: Output<List<ClusterNodeGroupArgs>>? = null

    private var paymentType: Output<String>? = null

    private var releaseVersion: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityMode: Output<String>? = null

    private var subscriptionConfig: Output<ClusterSubscriptionConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The application configurations of EMR cluster. See `application_configs` below.
     */
    @JvmName("kwbghtayktvywesd")
    public suspend fun applicationConfigs(`value`: Output<List<ClusterApplicationConfigArgs>>) {
        this.applicationConfigs = value
    }

    @JvmName("kyhnatsewetteful")
    public suspend fun applicationConfigs(vararg values: Output<ClusterApplicationConfigArgs>) {
        this.applicationConfigs = Output.all(values.asList())
    }

    /**
     * @param values The application configurations of EMR cluster. See `application_configs` below.
     */
    @JvmName("tpgyprcagpdxgjcb")
    public suspend fun applicationConfigs(values: List<Output<ClusterApplicationConfigArgs>>) {
        this.applicationConfigs = Output.all(values)
    }

    /**
     * @param value The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
     */
    @JvmName("sttdqywrkpicukpw")
    public suspend fun applications(`value`: Output<List<String>>) {
        this.applications = value
    }

    @JvmName("haugpiuodvyhkhen")
    public suspend fun applications(vararg values: Output<String>) {
        this.applications = Output.all(values.asList())
    }

    /**
     * @param values The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
     */
    @JvmName("faoorqicsfaotped")
    public suspend fun applications(values: List<Output<String>>) {
        this.applications = Output.all(values)
    }

    /**
     * @param value The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
     */
    @JvmName("fbontvfjfcsefemg")
    public suspend fun bootstrapScripts(`value`: Output<List<ClusterBootstrapScriptArgs>>) {
        this.bootstrapScripts = value
    }

    @JvmName("owxouqjdgkubkhgb")
    public suspend fun bootstrapScripts(vararg values: Output<ClusterBootstrapScriptArgs>) {
        this.bootstrapScripts = Output.all(values.asList())
    }

    /**
     * @param values The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
     */
    @JvmName("otvlcppxkiqgsdgf")
    public suspend fun bootstrapScripts(values: List<Output<ClusterBootstrapScriptArgs>>) {
        this.bootstrapScripts = Output.all(values)
    }

    /**
     * @param value The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
     */
    @JvmName("itlsrtydicedlslg")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
     */
    @JvmName("cwfmrxjufosuotue")
    public suspend fun clusterType(`value`: Output<String>) {
        this.clusterType = value
    }

    /**
     * @param value The deploy mode of EMR cluster. Supported value: NORMAL or HA.
     */
    @JvmName("ajhjprnchkswamia")
    public suspend fun deployMode(`value`: Output<String>) {
        this.deployMode = value
    }

    /**
     * @param value The log collect strategy of EMR cluster.
     */
    @JvmName("hnhwftykiicesbge")
    public suspend fun logCollectStrategy(`value`: Output<String>) {
        this.logCollectStrategy = value
    }

    /**
     * @param value The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
     */
    @JvmName("cejadxiumowkjvxk")
    public suspend fun nodeAttributes(`value`: Output<List<ClusterNodeAttributeArgs>>) {
        this.nodeAttributes = value
    }

    @JvmName("xkpldvvycumxyaut")
    public suspend fun nodeAttributes(vararg values: Output<ClusterNodeAttributeArgs>) {
        this.nodeAttributes = Output.all(values.asList())
    }

    /**
     * @param values The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
     */
    @JvmName("botafxheqsdkyduq")
    public suspend fun nodeAttributes(values: List<Output<ClusterNodeAttributeArgs>>) {
        this.nodeAttributes = Output.all(values)
    }

    /**
     * @param value Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
     */
    @JvmName("ydsesthcvenkykfh")
    public suspend fun nodeGroups(`value`: Output<List<ClusterNodeGroupArgs>>) {
        this.nodeGroups = value
    }

    @JvmName("cfkfwytcbenbjdyl")
    public suspend fun nodeGroups(vararg values: Output<ClusterNodeGroupArgs>) {
        this.nodeGroups = Output.all(values.asList())
    }

    /**
     * @param values Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
     */
    @JvmName("vlfibpsdmutjjvhg")
    public suspend fun nodeGroups(values: List<Output<ClusterNodeGroupArgs>>) {
        this.nodeGroups = Output.all(values)
    }

    /**
     * @param value Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
     */
    @JvmName("supgtnpdpklgxmsv")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
     */
    @JvmName("qugxfmetlcwihmto")
    public suspend fun releaseVersion(`value`: Output<String>) {
        this.releaseVersion = value
    }

    /**
     * @param value The Id of resource group which the emr-cluster belongs.
     */
    @JvmName("emejkostqryqgcel")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
     */
    @JvmName("rklvtvsvnncywvhi")
    public suspend fun securityMode(`value`: Output<String>) {
        this.securityMode = value
    }

    /**
     * @param value The detail configuration of subscription payment type. See `subscription_config` below.
     */
    @JvmName("yvldelriostkidja")
    public suspend fun subscriptionConfig(`value`: Output<ClusterSubscriptionConfigArgs>) {
        this.subscriptionConfig = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("sesequxfmxyywpmn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The application configurations of EMR cluster. See `application_configs` below.
     */
    @JvmName("tnnhsywpfmjusdsk")
    public suspend fun applicationConfigs(`value`: List<ClusterApplicationConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationConfigs = mapped
    }

    /**
     * @param argument The application configurations of EMR cluster. See `application_configs` below.
     */
    @JvmName("trpdukuowwempngs")
    public suspend fun applicationConfigs(argument: List<suspend ClusterApplicationConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterApplicationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationConfigs = mapped
    }

    /**
     * @param argument The application configurations of EMR cluster. See `application_configs` below.
     */
    @JvmName("bpceyilxujfhngpe")
    public suspend fun applicationConfigs(vararg argument: suspend ClusterApplicationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterApplicationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationConfigs = mapped
    }

    /**
     * @param argument The application configurations of EMR cluster. See `application_configs` below.
     */
    @JvmName("ttyluquanyptpkmg")
    public suspend fun applicationConfigs(argument: suspend ClusterApplicationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterApplicationConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationConfigs = mapped
    }

    /**
     * @param values The application configurations of EMR cluster. See `application_configs` below.
     */
    @JvmName("oercwopcuvcfjchu")
    public suspend fun applicationConfigs(vararg values: ClusterApplicationConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationConfigs = mapped
    }

    /**
     * @param value The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
     */
    @JvmName("pvvywvhpsenblfqr")
    public suspend fun applications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param values The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
     */
    @JvmName("ujfaprsgufsregju")
    public suspend fun applications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applications = mapped
    }

    /**
     * @param value The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
     */
    @JvmName("atdunkxpecslhutm")
    public suspend fun bootstrapScripts(`value`: List<ClusterBootstrapScriptArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootstrapScripts = mapped
    }

    /**
     * @param argument The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
     */
    @JvmName("gelewppvncnjjvly")
    public suspend fun bootstrapScripts(argument: List<suspend ClusterBootstrapScriptArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterBootstrapScriptArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bootstrapScripts = mapped
    }

    /**
     * @param argument The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
     */
    @JvmName("qkftgbkmfaicmuda")
    public suspend fun bootstrapScripts(vararg argument: suspend ClusterBootstrapScriptArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterBootstrapScriptArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bootstrapScripts = mapped
    }

    /**
     * @param argument The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
     */
    @JvmName("exixnhjehujhjeup")
    public suspend fun bootstrapScripts(argument: suspend ClusterBootstrapScriptArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterBootstrapScriptArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bootstrapScripts = mapped
    }

    /**
     * @param values The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
     */
    @JvmName("reojjduptiiealxm")
    public suspend fun bootstrapScripts(vararg values: ClusterBootstrapScriptArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bootstrapScripts = mapped
    }

    /**
     * @param value The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
     */
    @JvmName("wvppdkmkwhyxobnp")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
     */
    @JvmName("yqgojlluimchcrpy")
    public suspend fun clusterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The deploy mode of EMR cluster. Supported value: NORMAL or HA.
     */
    @JvmName("dtceeyujnatyxanj")
    public suspend fun deployMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployMode = mapped
    }

    /**
     * @param value The log collect strategy of EMR cluster.
     */
    @JvmName("anlwnskixyifnvry")
    public suspend fun logCollectStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logCollectStrategy = mapped
    }

    /**
     * @param value The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
     */
    @JvmName("ggnaqbslnfftadxg")
    public suspend fun nodeAttributes(`value`: List<ClusterNodeAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeAttributes = mapped
    }

    /**
     * @param argument The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
     */
    @JvmName("nnpjsfjuxydviskm")
    public suspend fun nodeAttributes(argument: List<suspend ClusterNodeAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeAttributes = mapped
    }

    /**
     * @param argument The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
     */
    @JvmName("eexrageednkjvrtq")
    public suspend fun nodeAttributes(vararg argument: suspend ClusterNodeAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeAttributeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeAttributes = mapped
    }

    /**
     * @param argument The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
     */
    @JvmName("vsrkalhydjdipeen")
    public suspend fun nodeAttributes(argument: suspend ClusterNodeAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterNodeAttributeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nodeAttributes = mapped
    }

    /**
     * @param values The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
     */
    @JvmName("bvrmwhhxkvvcqnpf")
    public suspend fun nodeAttributes(vararg values: ClusterNodeAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeAttributes = mapped
    }

    /**
     * @param value Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
     */
    @JvmName("yuhcunjlhblwstan")
    public suspend fun nodeGroups(`value`: List<ClusterNodeGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroups = mapped
    }

    /**
     * @param argument Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
     */
    @JvmName("ntdsxepimkutvwkb")
    public suspend fun nodeGroups(argument: List<suspend ClusterNodeGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeGroups = mapped
    }

    /**
     * @param argument Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
     */
    @JvmName("ylwduuihkdyikvso")
    public suspend fun nodeGroups(vararg argument: suspend ClusterNodeGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nodeGroups = mapped
    }

    /**
     * @param argument Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
     */
    @JvmName("teecofsypklgdmsu")
    public suspend fun nodeGroups(argument: suspend ClusterNodeGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterNodeGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nodeGroups = mapped
    }

    /**
     * @param values Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
     */
    @JvmName("fdvsbjawhoiaohga")
    public suspend fun nodeGroups(vararg values: ClusterNodeGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeGroups = mapped
    }

    /**
     * @param value Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
     */
    @JvmName("hvlapfljfsjlrcte")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
     */
    @JvmName("aayinewvimgogvul")
    public suspend fun releaseVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseVersion = mapped
    }

    /**
     * @param value The Id of resource group which the emr-cluster belongs.
     */
    @JvmName("prcdoahemyhirylr")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
     */
    @JvmName("kkfvlbqemeoxyytb")
    public suspend fun securityMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityMode = mapped
    }

    /**
     * @param value The detail configuration of subscription payment type. See `subscription_config` below.
     */
    @JvmName("dafpanexoaahktiy")
    public suspend fun subscriptionConfig(`value`: ClusterSubscriptionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionConfig = mapped
    }

    /**
     * @param argument The detail configuration of subscription payment type. See `subscription_config` below.
     */
    @JvmName("tycsvppswxaddhwd")
    public suspend fun subscriptionConfig(argument: suspend ClusterSubscriptionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterSubscriptionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subscriptionConfig = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("pkcouditmlsiabog")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("pfrypxcavuiukdiu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        applicationConfigs = applicationConfigs,
        applications = applications,
        bootstrapScripts = bootstrapScripts,
        clusterName = clusterName,
        clusterType = clusterType,
        deployMode = deployMode,
        logCollectStrategy = logCollectStrategy,
        nodeAttributes = nodeAttributes,
        nodeGroups = nodeGroups,
        paymentType = paymentType,
        releaseVersion = releaseVersion,
        resourceGroupId = resourceGroupId,
        securityMode = securityMode,
        subscriptionConfig = subscriptionConfig,
        tags = tags,
    )
}
