@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin

import com.pulumi.alicloud.emrv2.Emrv2Functions.getClustersPlain
import com.pulumi.alicloud.emrv2.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.alicloud.emrv2.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.alicloud.emrv2.kotlin.outputs.GetClustersResult
import com.pulumi.alicloud.emrv2.kotlin.outputs.GetClustersResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object Emrv2Functions {
    /**
     * This data source provides the Emr Clusters of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.199.0+.
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        toKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param clusterName The cluster name.
     * @param clusterStates The cluster states.
     * @param clusterTypes The cluster types.
     * @param ids A list of Cluster IDS.
     * @param maxResults The max results is used to list clusters for next page.
     * @param nameRegex A regex string to filter results by Cluster name.
     * @param nextToken The next token is used to list clusters for next page.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param paymentTypes The cluster payment types.
     * @param resourceGroupId The Resource Group ID.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(
        clusterName: String? = null,
        clusterStates: List<String>? = null,
        clusterTypes: List<String>? = null,
        ids: List<String>? = null,
        maxResults: Int? = null,
        nameRegex: String? = null,
        nextToken: String? = null,
        outputFile: String? = null,
        paymentTypes: List<String>? = null,
        resourceGroupId: String? = null,
        tags: Map<String, String>? = null,
    ): GetClustersResult {
        val argument = GetClustersPlainArgs(
            clusterName = clusterName,
            clusterStates = clusterStates,
            clusterTypes = clusterTypes,
            ids = ids,
            maxResults = maxResults,
            nameRegex = nameRegex,
            nextToken = nextToken,
            outputFile = outputFile,
            paymentTypes = paymentTypes,
            resourceGroupId = resourceGroupId,
            tags = tags,
        )
        return toKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;emrv2&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getClustersPlain(builtArgument.toJava()).await())
    }
}
