@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterApplicationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The application name of EMR cluster which has installed.
 * @property configDescription The configuration description of application installed.
 * @property configFileName The configuration file name of application installed.
 * @property configItemKey The configuration item key of application installed.
 * @property configItemValue The configuration item value of application installed.
 * @property configScope The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
 * @property nodeGroupId The configuration effected which node group id of emr cluster.
 * @property nodeGroupName The configuration effected which node group name of emr cluster.
 */
public data class ClusterApplicationConfigArgs(
    public val applicationName: Output<String>,
    public val configDescription: Output<String>? = null,
    public val configFileName: Output<String>,
    public val configItemKey: Output<String>,
    public val configItemValue: Output<String>,
    public val configScope: Output<String>? = null,
    public val nodeGroupId: Output<String>? = null,
    public val nodeGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterApplicationConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterApplicationConfigArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterApplicationConfigArgs.builder()
            .applicationName(applicationName.applyValue({ args0 -> args0 }))
            .configDescription(configDescription?.applyValue({ args0 -> args0 }))
            .configFileName(configFileName.applyValue({ args0 -> args0 }))
            .configItemKey(configItemKey.applyValue({ args0 -> args0 }))
            .configItemValue(configItemValue.applyValue({ args0 -> args0 }))
            .configScope(configScope?.applyValue({ args0 -> args0 }))
            .nodeGroupId(nodeGroupId?.applyValue({ args0 -> args0 }))
            .nodeGroupName(nodeGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterApplicationConfigArgs].
 */
@PulumiTagMarker
public class ClusterApplicationConfigArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var configDescription: Output<String>? = null

    private var configFileName: Output<String>? = null

    private var configItemKey: Output<String>? = null

    private var configItemValue: Output<String>? = null

    private var configScope: Output<String>? = null

    private var nodeGroupId: Output<String>? = null

    private var nodeGroupName: Output<String>? = null

    /**
     * @param value The application name of EMR cluster which has installed.
     */
    @JvmName("punrdlrttfwrxusk")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The configuration description of application installed.
     */
    @JvmName("ptlyojkrvnufryjh")
    public suspend fun configDescription(`value`: Output<String>) {
        this.configDescription = value
    }

    /**
     * @param value The configuration file name of application installed.
     */
    @JvmName("mfophfhkfbjwkgly")
    public suspend fun configFileName(`value`: Output<String>) {
        this.configFileName = value
    }

    /**
     * @param value The configuration item key of application installed.
     */
    @JvmName("anygheonhvrgwjjp")
    public suspend fun configItemKey(`value`: Output<String>) {
        this.configItemKey = value
    }

    /**
     * @param value The configuration item value of application installed.
     */
    @JvmName("hoeslfliatkxavxd")
    public suspend fun configItemValue(`value`: Output<String>) {
        this.configItemValue = value
    }

    /**
     * @param value The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
     */
    @JvmName("ytjdvlaepxmqvxie")
    public suspend fun configScope(`value`: Output<String>) {
        this.configScope = value
    }

    /**
     * @param value The configuration effected which node group id of emr cluster.
     */
    @JvmName("rrgdvxaqqwukgxdh")
    public suspend fun nodeGroupId(`value`: Output<String>) {
        this.nodeGroupId = value
    }

    /**
     * @param value The configuration effected which node group name of emr cluster.
     */
    @JvmName("mbocgqviosnrvubn")
    public suspend fun nodeGroupName(`value`: Output<String>) {
        this.nodeGroupName = value
    }

    /**
     * @param value The application name of EMR cluster which has installed.
     */
    @JvmName("uaaqydatvjplowao")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The configuration description of application installed.
     */
    @JvmName("pdphdjxcnahhfbbn")
    public suspend fun configDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configDescription = mapped
    }

    /**
     * @param value The configuration file name of application installed.
     */
    @JvmName("cembkobuopmvkapd")
    public suspend fun configFileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configFileName = mapped
    }

    /**
     * @param value The configuration item key of application installed.
     */
    @JvmName("bkccqsqlsemgvxeb")
    public suspend fun configItemKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configItemKey = mapped
    }

    /**
     * @param value The configuration item value of application installed.
     */
    @JvmName("svgxxpbperukyqwf")
    public suspend fun configItemValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configItemValue = mapped
    }

    /**
     * @param value The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
     */
    @JvmName("bgtrmaqcrffxgjil")
    public suspend fun configScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configScope = mapped
    }

    /**
     * @param value The configuration effected which node group id of emr cluster.
     */
    @JvmName("lqoetgonpgbluilq")
    public suspend fun nodeGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupId = mapped
    }

    /**
     * @param value The configuration effected which node group name of emr cluster.
     */
    @JvmName("rerbopllnnrccbis")
    public suspend fun nodeGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupName = mapped
    }

    internal fun build(): ClusterApplicationConfigArgs = ClusterApplicationConfigArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        configDescription = configDescription,
        configFileName = configFileName ?: throw PulumiNullFieldException("configFileName"),
        configItemKey = configItemKey ?: throw PulumiNullFieldException("configItemKey"),
        configItemValue = configItemValue ?: throw PulumiNullFieldException("configItemValue"),
        configScope = configScope,
        nodeGroupId = nodeGroupId,
        nodeGroupName = nodeGroupName,
    )
}
