@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property executionFailStrategy The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
 * @property executionMoment The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
 * @property nodeSelector The bootstrap scripts execution target. See `node_selector` below.
 * @property priority The bootstrap scripts priority.
 * @property scriptArgs The bootstrap script args, e.g. "--a=b".
 * @property scriptName The bootstrap script name.
 * @property scriptPath The bootstrap script path, e.g. "oss://bucket/path".
 */
public data class ClusterBootstrapScriptArgs(
    public val executionFailStrategy: Output<String>,
    public val executionMoment: Output<String>,
    public val nodeSelector: Output<ClusterBootstrapScriptNodeSelectorArgs>,
    @Deprecated(
        message = """
  Field 'priority' has been deprecated from provider version 1.227.0.
  """,
    )
    public val priority: Output<Int>? = null,
    public val scriptArgs: Output<String>,
    public val scriptName: Output<String>,
    public val scriptPath: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptArgs.builder()
            .executionFailStrategy(executionFailStrategy.applyValue({ args0 -> args0 }))
            .executionMoment(executionMoment.applyValue({ args0 -> args0 }))
            .nodeSelector(nodeSelector.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .scriptArgs(scriptArgs.applyValue({ args0 -> args0 }))
            .scriptName(scriptName.applyValue({ args0 -> args0 }))
            .scriptPath(scriptPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBootstrapScriptArgs].
 */
@PulumiTagMarker
public class ClusterBootstrapScriptArgsBuilder internal constructor() {
    private var executionFailStrategy: Output<String>? = null

    private var executionMoment: Output<String>? = null

    private var nodeSelector: Output<ClusterBootstrapScriptNodeSelectorArgs>? = null

    private var priority: Output<Int>? = null

    private var scriptArgs: Output<String>? = null

    private var scriptName: Output<String>? = null

    private var scriptPath: Output<String>? = null

    /**
     * @param value The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
     */
    @JvmName("jtqbqyxpeqetaeqs")
    public suspend fun executionFailStrategy(`value`: Output<String>) {
        this.executionFailStrategy = value
    }

    /**
     * @param value The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
     */
    @JvmName("bdyglrytxrgxpkya")
    public suspend fun executionMoment(`value`: Output<String>) {
        this.executionMoment = value
    }

    /**
     * @param value The bootstrap scripts execution target. See `node_selector` below.
     */
    @JvmName("yvwqfjljiqstfsaj")
    public suspend fun nodeSelector(`value`: Output<ClusterBootstrapScriptNodeSelectorArgs>) {
        this.nodeSelector = value
    }

    /**
     * @param value The bootstrap scripts priority.
     */
    @Deprecated(
        message = """
  Field 'priority' has been deprecated from provider version 1.227.0.
  """,
    )
    @JvmName("fbgbpmtekebdaupk")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The bootstrap script args, e.g. "--a=b".
     */
    @JvmName("ufbnhmrdwagxtnvj")
    public suspend fun scriptArgs(`value`: Output<String>) {
        this.scriptArgs = value
    }

    /**
     * @param value The bootstrap script name.
     */
    @JvmName("lxbqbabvfgiovtqw")
    public suspend fun scriptName(`value`: Output<String>) {
        this.scriptName = value
    }

    /**
     * @param value The bootstrap script path, e.g. "oss://bucket/path".
     */
    @JvmName("kjgydjbbmhjdcgdx")
    public suspend fun scriptPath(`value`: Output<String>) {
        this.scriptPath = value
    }

    /**
     * @param value The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
     */
    @JvmName("fsirudvcqiqiwywv")
    public suspend fun executionFailStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionFailStrategy = mapped
    }

    /**
     * @param value The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
     */
    @JvmName("faiwyaancdkoetjt")
    public suspend fun executionMoment(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionMoment = mapped
    }

    /**
     * @param value The bootstrap scripts execution target. See `node_selector` below.
     */
    @JvmName("kekgjqeyrpuoardi")
    public suspend fun nodeSelector(`value`: ClusterBootstrapScriptNodeSelectorArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSelector = mapped
    }

    /**
     * @param argument The bootstrap scripts execution target. See `node_selector` below.
     */
    @JvmName("danfvqmnthtldlfw")
    public suspend fun nodeSelector(argument: suspend ClusterBootstrapScriptNodeSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterBootstrapScriptNodeSelectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nodeSelector = mapped
    }

    /**
     * @param value The bootstrap scripts priority.
     */
    @Deprecated(
        message = """
  Field 'priority' has been deprecated from provider version 1.227.0.
  """,
    )
    @JvmName("rtoouyqxlhcsocoi")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The bootstrap script args, e.g. "--a=b".
     */
    @JvmName("xlpwsddostlsudlv")
    public suspend fun scriptArgs(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptArgs = mapped
    }

    /**
     * @param value The bootstrap script name.
     */
    @JvmName("dxqntxvdnsyqryeh")
    public suspend fun scriptName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptName = mapped
    }

    /**
     * @param value The bootstrap script path, e.g. "oss://bucket/path".
     */
    @JvmName("qwprcwqoucahycih")
    public suspend fun scriptPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scriptPath = mapped
    }

    internal fun build(): ClusterBootstrapScriptArgs = ClusterBootstrapScriptArgs(
        executionFailStrategy = executionFailStrategy ?: throw
            PulumiNullFieldException("executionFailStrategy"),
        executionMoment = executionMoment ?: throw PulumiNullFieldException("executionMoment"),
        nodeSelector = nodeSelector ?: throw PulumiNullFieldException("nodeSelector"),
        priority = priority,
        scriptArgs = scriptArgs ?: throw PulumiNullFieldException("scriptArgs"),
        scriptName = scriptName ?: throw PulumiNullFieldException("scriptName"),
        scriptPath = scriptPath ?: throw PulumiNullFieldException("scriptPath"),
    )
}
