@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptNodeSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property nodeGroupId
 * @property nodeGroupIds The bootstrap scripts execution target node group ids.
 * @property nodeGroupName
 * @property nodeGroupNames The bootstrap scripts execution target node group names.
 * @property nodeGroupTypes The bootstrap scripts execution target node group types.
 * @property nodeNames The bootstrap scripts execution target node names.
 * @property nodeSelectType The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
 */
public data class ClusterBootstrapScriptNodeSelectorArgs(
    @Deprecated(
        message = """
  Field 'node_group_id' has been deprecated from provider version 1.227.0. New field
      'node_group_ids' replaces it.
  """,
    )
    public val nodeGroupId: Output<String>? = null,
    public val nodeGroupIds: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field 'node_group_name' has been deprecated from provider version 1.227.0. New field
      'node_group_names' replaces it.
  """,
    )
    public val nodeGroupName: Output<String>? = null,
    public val nodeGroupNames: Output<List<String>>? = null,
    public val nodeGroupTypes: Output<List<String>>? = null,
    public val nodeNames: Output<List<String>>? = null,
    public val nodeSelectType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptNodeSelectorArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptNodeSelectorArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterBootstrapScriptNodeSelectorArgs.builder()
            .nodeGroupId(nodeGroupId?.applyValue({ args0 -> args0 }))
            .nodeGroupIds(nodeGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nodeGroupName(nodeGroupName?.applyValue({ args0 -> args0 }))
            .nodeGroupNames(nodeGroupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nodeGroupTypes(nodeGroupTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nodeNames(nodeNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nodeSelectType(nodeSelectType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterBootstrapScriptNodeSelectorArgs].
 */
@PulumiTagMarker
public class ClusterBootstrapScriptNodeSelectorArgsBuilder internal constructor() {
    private var nodeGroupId: Output<String>? = null

    private var nodeGroupIds: Output<List<String>>? = null

    private var nodeGroupName: Output<String>? = null

    private var nodeGroupNames: Output<List<String>>? = null

    private var nodeGroupTypes: Output<List<String>>? = null

    private var nodeNames: Output<List<String>>? = null

    private var nodeSelectType: Output<String>? = null

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'node_group_id' has been deprecated from provider version 1.227.0. New field
      'node_group_ids' replaces it.
  """,
    )
    @JvmName("oioinnrjyrdritkl")
    public suspend fun nodeGroupId(`value`: Output<String>) {
        this.nodeGroupId = value
    }

    /**
     * @param value The bootstrap scripts execution target node group ids.
     */
    @JvmName("lixbabkgppriukwn")
    public suspend fun nodeGroupIds(`value`: Output<List<String>>) {
        this.nodeGroupIds = value
    }

    @JvmName("utvwpcifkdintyrp")
    public suspend fun nodeGroupIds(vararg values: Output<String>) {
        this.nodeGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The bootstrap scripts execution target node group ids.
     */
    @JvmName("eeydryifsvqoekmo")
    public suspend fun nodeGroupIds(values: List<Output<String>>) {
        this.nodeGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'node_group_name' has been deprecated from provider version 1.227.0. New field
      'node_group_names' replaces it.
  """,
    )
    @JvmName("lmhghwmlxbxaewvs")
    public suspend fun nodeGroupName(`value`: Output<String>) {
        this.nodeGroupName = value
    }

    /**
     * @param value The bootstrap scripts execution target node group names.
     */
    @JvmName("mmnbwagotbhfflcq")
    public suspend fun nodeGroupNames(`value`: Output<List<String>>) {
        this.nodeGroupNames = value
    }

    @JvmName("mvxxcrjhmobhmqow")
    public suspend fun nodeGroupNames(vararg values: Output<String>) {
        this.nodeGroupNames = Output.all(values.asList())
    }

    /**
     * @param values The bootstrap scripts execution target node group names.
     */
    @JvmName("mtiiosuhkevnyiiv")
    public suspend fun nodeGroupNames(values: List<Output<String>>) {
        this.nodeGroupNames = Output.all(values)
    }

    /**
     * @param value The bootstrap scripts execution target node group types.
     */
    @JvmName("qjesgcewiriqgxij")
    public suspend fun nodeGroupTypes(`value`: Output<List<String>>) {
        this.nodeGroupTypes = value
    }

    @JvmName("wtfvwqtdqayjbnyr")
    public suspend fun nodeGroupTypes(vararg values: Output<String>) {
        this.nodeGroupTypes = Output.all(values.asList())
    }

    /**
     * @param values The bootstrap scripts execution target node group types.
     */
    @JvmName("lyybamedinogwkdi")
    public suspend fun nodeGroupTypes(values: List<Output<String>>) {
        this.nodeGroupTypes = Output.all(values)
    }

    /**
     * @param value The bootstrap scripts execution target node names.
     */
    @JvmName("ydwunukdmbobyard")
    public suspend fun nodeNames(`value`: Output<List<String>>) {
        this.nodeNames = value
    }

    @JvmName("sufrmtcaokprhveo")
    public suspend fun nodeNames(vararg values: Output<String>) {
        this.nodeNames = Output.all(values.asList())
    }

    /**
     * @param values The bootstrap scripts execution target node names.
     */
    @JvmName("bjfwgaxbjiydevpp")
    public suspend fun nodeNames(values: List<Output<String>>) {
        this.nodeNames = Output.all(values)
    }

    /**
     * @param value The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
     */
    @JvmName("njliybuxybtcajql")
    public suspend fun nodeSelectType(`value`: Output<String>) {
        this.nodeSelectType = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'node_group_id' has been deprecated from provider version 1.227.0. New field
      'node_group_ids' replaces it.
  """,
    )
    @JvmName("xjvpmdrtepxjoagb")
    public suspend fun nodeGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupId = mapped
    }

    /**
     * @param value The bootstrap scripts execution target node group ids.
     */
    @JvmName("onapnpisyyacrlpd")
    public suspend fun nodeGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupIds = mapped
    }

    /**
     * @param values The bootstrap scripts execution target node group ids.
     */
    @JvmName("gssierrrfkaluslu")
    public suspend fun nodeGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeGroupIds = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'node_group_name' has been deprecated from provider version 1.227.0. New field
      'node_group_names' replaces it.
  """,
    )
    @JvmName("fvcqorxgojiwuily")
    public suspend fun nodeGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupName = mapped
    }

    /**
     * @param value The bootstrap scripts execution target node group names.
     */
    @JvmName("wtovbbpdwcbwfnvj")
    public suspend fun nodeGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupNames = mapped
    }

    /**
     * @param values The bootstrap scripts execution target node group names.
     */
    @JvmName("pnpegrbmwmfarehd")
    public suspend fun nodeGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeGroupNames = mapped
    }

    /**
     * @param value The bootstrap scripts execution target node group types.
     */
    @JvmName("gubquwxfkgvfihgb")
    public suspend fun nodeGroupTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupTypes = mapped
    }

    /**
     * @param values The bootstrap scripts execution target node group types.
     */
    @JvmName("mxqufxjweuiuiugk")
    public suspend fun nodeGroupTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeGroupTypes = mapped
    }

    /**
     * @param value The bootstrap scripts execution target node names.
     */
    @JvmName("wqkqlaqthbvnayvk")
    public suspend fun nodeNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeNames = mapped
    }

    /**
     * @param values The bootstrap scripts execution target node names.
     */
    @JvmName("hmueqpjrdaxmkffn")
    public suspend fun nodeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeNames = mapped
    }

    /**
     * @param value The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
     */
    @JvmName("jfpoxjegwvyoyvsg")
    public suspend fun nodeSelectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSelectType = mapped
    }

    internal fun build(): ClusterBootstrapScriptNodeSelectorArgs =
        ClusterBootstrapScriptNodeSelectorArgs(
            nodeGroupId = nodeGroupId,
            nodeGroupIds = nodeGroupIds,
            nodeGroupName = nodeGroupName,
            nodeGroupNames = nodeGroupNames,
            nodeGroupTypes = nodeGroupTypes,
            nodeNames = nodeNames,
            nodeSelectType = nodeSelectType ?: throw PulumiNullFieldException("nodeSelectType"),
        )
}
