@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataDiskEncrypted Whether to enable data disk encryption.
 * @property dataDiskKmsKeyId The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
 * @property keyPairName The name of the key pair.
 * @property ramRole Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
 * @property securityGroupId Security Group ID for Cluster.
 * @property vpcId Used to retrieve instances belong to specified VPC.
 * @property zoneId Zone ID, e.g. cn-hangzhou-i
 */
public data class ClusterNodeAttributeArgs(
    public val dataDiskEncrypted: Output<Boolean>? = null,
    public val dataDiskKmsKeyId: Output<String>? = null,
    public val keyPairName: Output<String>,
    public val ramRole: Output<String>,
    public val securityGroupId: Output<String>,
    public val vpcId: Output<String>,
    public val zoneId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeAttributeArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeAttributeArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeAttributeArgs.builder()
            .dataDiskEncrypted(dataDiskEncrypted?.applyValue({ args0 -> args0 }))
            .dataDiskKmsKeyId(dataDiskKmsKeyId?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName.applyValue({ args0 -> args0 }))
            .ramRole(ramRole.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 }))
            .zoneId(zoneId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeAttributeArgs].
 */
@PulumiTagMarker
public class ClusterNodeAttributeArgsBuilder internal constructor() {
    private var dataDiskEncrypted: Output<Boolean>? = null

    private var dataDiskKmsKeyId: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var ramRole: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Whether to enable data disk encryption.
     */
    @JvmName("tfgdfjxbdtgxrnsh")
    public suspend fun dataDiskEncrypted(`value`: Output<Boolean>) {
        this.dataDiskEncrypted = value
    }

    /**
     * @param value The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
     */
    @JvmName("vbacdgyavoqjudsa")
    public suspend fun dataDiskKmsKeyId(`value`: Output<String>) {
        this.dataDiskKmsKeyId = value
    }

    /**
     * @param value The name of the key pair.
     */
    @JvmName("flhfqcdqcnggbrnm")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
     */
    @JvmName("rrypqurpqwvskdnx")
    public suspend fun ramRole(`value`: Output<String>) {
        this.ramRole = value
    }

    /**
     * @param value Security Group ID for Cluster.
     */
    @JvmName("pqnljopheudnbqii")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Used to retrieve instances belong to specified VPC.
     */
    @JvmName("iolroadkpvwhieff")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Zone ID, e.g. cn-hangzhou-i
     */
    @JvmName("sojjidiayiwfbisq")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Whether to enable data disk encryption.
     */
    @JvmName("owsqmymvkfxmnorc")
    public suspend fun dataDiskEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskEncrypted = mapped
    }

    /**
     * @param value The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
     */
    @JvmName("hcxbywpeawnwgfsb")
    public suspend fun dataDiskKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskKmsKeyId = mapped
    }

    /**
     * @param value The name of the key pair.
     */
    @JvmName("rcvhrdjgqofqngfe")
    public suspend fun keyPairName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
     */
    @JvmName("xlxtfuetphyqjmtr")
    public suspend fun ramRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ramRole = mapped
    }

    /**
     * @param value Security Group ID for Cluster.
     */
    @JvmName("fhggfxywfcfuflyc")
    public suspend fun securityGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Used to retrieve instances belong to specified VPC.
     */
    @JvmName("nvruivggfvjyqrbs")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value Zone ID, e.g. cn-hangzhou-i
     */
    @JvmName("bunflyalchhejvou")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ClusterNodeAttributeArgs = ClusterNodeAttributeArgs(
        dataDiskEncrypted = dataDiskEncrypted,
        dataDiskKmsKeyId = dataDiskKmsKeyId,
        keyPairName = keyPairName ?: throw PulumiNullFieldException("keyPairName"),
        ramRole = ramRole ?: throw PulumiNullFieldException("ramRole"),
        securityGroupId = securityGroupId ?: throw PulumiNullFieldException("securityGroupId"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
