@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property additionalSecurityGroupIds Additional security Group IDS for Cluster, you can also specify this key for each node group.
 * @property autoScalingPolicy The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
 * @property costOptimizedConfig The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
 * @property dataDisks Host Ecs data disks information in this node group. See `data_disks` below.
 * @property deploymentSetStrategy Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP.
 * @property gracefulShutdown Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
 * @property instanceTypes Host Ecs instance types.
 * @property nodeCount Host Ecs number in this node group.
 * @property nodeGroupName The node group name of emr cluster.
 * @property nodeGroupType The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0.
 * @property nodeResizeStrategy Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
 * @property paymentType Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
 * @property spotBidPrices The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
 * @property spotInstanceRemedy Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
 * @property subscriptionConfig The detail configuration of subscription payment type. See `subscription_config` below.
 * @property systemDisk Host Ecs system disk information in this node group. See `system_disk` below.
 * @property vswitchIds Global vSwitch ids, you can also specify it in node group.
 * @property withPublicIp Whether the node has a public IP address enabled.
 */
public data class ClusterNodeGroupArgs(
    public val additionalSecurityGroupIds: Output<List<String>>? = null,
    public val autoScalingPolicy: Output<ClusterNodeGroupAutoScalingPolicyArgs>? = null,
    public val costOptimizedConfig: Output<ClusterNodeGroupCostOptimizedConfigArgs>? = null,
    public val dataDisks: Output<List<ClusterNodeGroupDataDiskArgs>>,
    public val deploymentSetStrategy: Output<String>? = null,
    public val gracefulShutdown: Output<Boolean>? = null,
    public val instanceTypes: Output<List<String>>,
    public val nodeCount: Output<Int>,
    public val nodeGroupName: Output<String>,
    public val nodeGroupType: Output<String>,
    public val nodeResizeStrategy: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val spotBidPrices: Output<List<ClusterNodeGroupSpotBidPriceArgs>>? = null,
    public val spotInstanceRemedy: Output<Boolean>? = null,
    public val subscriptionConfig: Output<ClusterNodeGroupSubscriptionConfigArgs>? = null,
    public val systemDisk: Output<ClusterNodeGroupSystemDiskArgs>,
    public val vswitchIds: Output<List<String>>? = null,
    public val withPublicIp: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupArgs.builder()
            .additionalSecurityGroupIds(
                additionalSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .autoScalingPolicy(autoScalingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .costOptimizedConfig(
                costOptimizedConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataDisks(
                dataDisks.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deploymentSetStrategy(deploymentSetStrategy?.applyValue({ args0 -> args0 }))
            .gracefulShutdown(gracefulShutdown?.applyValue({ args0 -> args0 }))
            .instanceTypes(instanceTypes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .nodeCount(nodeCount.applyValue({ args0 -> args0 }))
            .nodeGroupName(nodeGroupName.applyValue({ args0 -> args0 }))
            .nodeGroupType(nodeGroupType.applyValue({ args0 -> args0 }))
            .nodeResizeStrategy(nodeResizeStrategy?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .spotBidPrices(
                spotBidPrices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .spotInstanceRemedy(spotInstanceRemedy?.applyValue({ args0 -> args0 }))
            .subscriptionConfig(
                subscriptionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .systemDisk(systemDisk.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .withPublicIp(withPublicIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupArgsBuilder internal constructor() {
    private var additionalSecurityGroupIds: Output<List<String>>? = null

    private var autoScalingPolicy: Output<ClusterNodeGroupAutoScalingPolicyArgs>? = null

    private var costOptimizedConfig: Output<ClusterNodeGroupCostOptimizedConfigArgs>? = null

    private var dataDisks: Output<List<ClusterNodeGroupDataDiskArgs>>? = null

    private var deploymentSetStrategy: Output<String>? = null

    private var gracefulShutdown: Output<Boolean>? = null

    private var instanceTypes: Output<List<String>>? = null

    private var nodeCount: Output<Int>? = null

    private var nodeGroupName: Output<String>? = null

    private var nodeGroupType: Output<String>? = null

    private var nodeResizeStrategy: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var spotBidPrices: Output<List<ClusterNodeGroupSpotBidPriceArgs>>? = null

    private var spotInstanceRemedy: Output<Boolean>? = null

    private var subscriptionConfig: Output<ClusterNodeGroupSubscriptionConfigArgs>? = null

    private var systemDisk: Output<ClusterNodeGroupSystemDiskArgs>? = null

    private var vswitchIds: Output<List<String>>? = null

    private var withPublicIp: Output<Boolean>? = null

    /**
     * @param value Additional security Group IDS for Cluster, you can also specify this key for each node group.
     */
    @JvmName("vupyvqjjkudrnndu")
    public suspend fun additionalSecurityGroupIds(`value`: Output<List<String>>) {
        this.additionalSecurityGroupIds = value
    }

    @JvmName("mlvekciwolugdgdi")
    public suspend fun additionalSecurityGroupIds(vararg values: Output<String>) {
        this.additionalSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Additional security Group IDS for Cluster, you can also specify this key for each node group.
     */
    @JvmName("hawdxfjxbfxajjly")
    public suspend fun additionalSecurityGroupIds(values: List<Output<String>>) {
        this.additionalSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
     */
    @JvmName("retrauixiaomupja")
    public suspend fun autoScalingPolicy(`value`: Output<ClusterNodeGroupAutoScalingPolicyArgs>) {
        this.autoScalingPolicy = value
    }

    /**
     * @param value The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
     */
    @JvmName("lxldnaeepelornvj")
    public suspend fun costOptimizedConfig(`value`: Output<ClusterNodeGroupCostOptimizedConfigArgs>) {
        this.costOptimizedConfig = value
    }

    /**
     * @param value Host Ecs data disks information in this node group. See `data_disks` below.
     */
    @JvmName("yxdobfhwgvhbskyg")
    public suspend fun dataDisks(`value`: Output<List<ClusterNodeGroupDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("yojfjrvnwaqgxhvh")
    public suspend fun dataDisks(vararg values: Output<ClusterNodeGroupDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Host Ecs data disks information in this node group. See `data_disks` below.
     */
    @JvmName("cxwkjbdaapomtkgt")
    public suspend fun dataDisks(values: List<Output<ClusterNodeGroupDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP.
     */
    @JvmName("fqgavlfekmydwfqo")
    public suspend fun deploymentSetStrategy(`value`: Output<String>) {
        this.deploymentSetStrategy = value
    }

    /**
     * @param value Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
     */
    @JvmName("qhtoctwihyisnbgd")
    public suspend fun gracefulShutdown(`value`: Output<Boolean>) {
        this.gracefulShutdown = value
    }

    /**
     * @param value Host Ecs instance types.
     */
    @JvmName("epyuxdpyjjiuykcv")
    public suspend fun instanceTypes(`value`: Output<List<String>>) {
        this.instanceTypes = value
    }

    @JvmName("rlvcyvcmvixexofo")
    public suspend fun instanceTypes(vararg values: Output<String>) {
        this.instanceTypes = Output.all(values.asList())
    }

    /**
     * @param values Host Ecs instance types.
     */
    @JvmName("vcnuktjupccooxbf")
    public suspend fun instanceTypes(values: List<Output<String>>) {
        this.instanceTypes = Output.all(values)
    }

    /**
     * @param value Host Ecs number in this node group.
     */
    @JvmName("samevqcmskrqlasp")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value The node group name of emr cluster.
     */
    @JvmName("xaflyfopwiciblbl")
    public suspend fun nodeGroupName(`value`: Output<String>) {
        this.nodeGroupName = value
    }

    /**
     * @param value The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0.
     */
    @JvmName("xvkraawcunsiyyds")
    public suspend fun nodeGroupType(`value`: Output<String>) {
        this.nodeGroupType = value
    }

    /**
     * @param value Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
     */
    @JvmName("mifbeytngrsbxqro")
    public suspend fun nodeResizeStrategy(`value`: Output<String>) {
        this.nodeResizeStrategy = value
    }

    /**
     * @param value Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
     */
    @JvmName("wxvreqgbnlkiulab")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
     */
    @JvmName("tkiftdryfhwttrys")
    public suspend fun spotBidPrices(`value`: Output<List<ClusterNodeGroupSpotBidPriceArgs>>) {
        this.spotBidPrices = value
    }

    @JvmName("plvhxlyvxokcbyrl")
    public suspend fun spotBidPrices(vararg values: Output<ClusterNodeGroupSpotBidPriceArgs>) {
        this.spotBidPrices = Output.all(values.asList())
    }

    /**
     * @param values The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
     */
    @JvmName("gcvgolweobaupver")
    public suspend fun spotBidPrices(values: List<Output<ClusterNodeGroupSpotBidPriceArgs>>) {
        this.spotBidPrices = Output.all(values)
    }

    /**
     * @param value Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
     */
    @JvmName("bwadutrfkfgsrgra")
    public suspend fun spotInstanceRemedy(`value`: Output<Boolean>) {
        this.spotInstanceRemedy = value
    }

    /**
     * @param value The detail configuration of subscription payment type. See `subscription_config` below.
     */
    @JvmName("elttvtbhcdogxbba")
    public suspend fun subscriptionConfig(`value`: Output<ClusterNodeGroupSubscriptionConfigArgs>) {
        this.subscriptionConfig = value
    }

    /**
     * @param value Host Ecs system disk information in this node group. See `system_disk` below.
     */
    @JvmName("wlxlwmrshoxeapgq")
    public suspend fun systemDisk(`value`: Output<ClusterNodeGroupSystemDiskArgs>) {
        this.systemDisk = value
    }

    /**
     * @param value Global vSwitch ids, you can also specify it in node group.
     */
    @JvmName("bdqghpxdffwmeqjj")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("tjvahttyjldpayql")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values Global vSwitch ids, you can also specify it in node group.
     */
    @JvmName("wyshquqqdlsbwcus")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value Whether the node has a public IP address enabled.
     */
    @JvmName("biodgbmcylxhvgjf")
    public suspend fun withPublicIp(`value`: Output<Boolean>) {
        this.withPublicIp = value
    }

    /**
     * @param value Additional security Group IDS for Cluster, you can also specify this key for each node group.
     */
    @JvmName("yqxtdwnrocjqyxkn")
    public suspend fun additionalSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalSecurityGroupIds = mapped
    }

    /**
     * @param values Additional security Group IDS for Cluster, you can also specify this key for each node group.
     */
    @JvmName("ondngpmioorwpmoh")
    public suspend fun additionalSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalSecurityGroupIds = mapped
    }

    /**
     * @param value The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
     */
    @JvmName("gopdbdxxvdmwrphj")
    public suspend fun autoScalingPolicy(`value`: ClusterNodeGroupAutoScalingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingPolicy = mapped
    }

    /**
     * @param argument The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
     */
    @JvmName("arlbhsjnbyfgujfo")
    public suspend fun autoScalingPolicy(argument: suspend ClusterNodeGroupAutoScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterNodeGroupAutoScalingPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScalingPolicy = mapped
    }

    /**
     * @param value The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
     */
    @JvmName("eadnarchjbmnnntc")
    public suspend fun costOptimizedConfig(`value`: ClusterNodeGroupCostOptimizedConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costOptimizedConfig = mapped
    }

    /**
     * @param argument The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
     */
    @JvmName("pubntxwdoxtndgyl")
    public suspend fun costOptimizedConfig(argument: suspend ClusterNodeGroupCostOptimizedConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterNodeGroupCostOptimizedConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.costOptimizedConfig = mapped
    }

    /**
     * @param value Host Ecs data disks information in this node group. See `data_disks` below.
     */
    @JvmName("afcygjvsccwfjvkf")
    public suspend fun dataDisks(`value`: List<ClusterNodeGroupDataDiskArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Host Ecs data disks information in this node group. See `data_disks` below.
     */
    @JvmName("icxhyrucjrfcqvtj")
    public suspend fun dataDisks(argument: List<suspend ClusterNodeGroupDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Host Ecs data disks information in this node group. See `data_disks` below.
     */
    @JvmName("euybcuprvyuinchi")
    public suspend fun dataDisks(vararg argument: suspend ClusterNodeGroupDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Host Ecs data disks information in this node group. See `data_disks` below.
     */
    @JvmName("mcfrvvgtwbacqheu")
    public suspend fun dataDisks(argument: suspend ClusterNodeGroupDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterNodeGroupDataDiskArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Host Ecs data disks information in this node group. See `data_disks` below.
     */
    @JvmName("pnvryqtdroqilpsg")
    public suspend fun dataDisks(vararg values: ClusterNodeGroupDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP.
     */
    @JvmName("uvgjstwqoeqbyfcv")
    public suspend fun deploymentSetStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSetStrategy = mapped
    }

    /**
     * @param value Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
     */
    @JvmName("pxkqqvuhkvfptkjh")
    public suspend fun gracefulShutdown(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gracefulShutdown = mapped
    }

    /**
     * @param value Host Ecs instance types.
     */
    @JvmName("eepbbttifjyeupqu")
    public suspend fun instanceTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param values Host Ecs instance types.
     */
    @JvmName("msdbdmfclwmtdpio")
    public suspend fun instanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value Host Ecs number in this node group.
     */
    @JvmName("pkdyhjlpwvstcvvn")
    public suspend fun nodeCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value The node group name of emr cluster.
     */
    @JvmName("ivaavnfdymogocdp")
    public suspend fun nodeGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeGroupName = mapped
    }

    /**
     * @param value The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0.
     */
    @JvmName("hxhdrqdcrvpeqfwl")
    public suspend fun nodeGroupType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeGroupType = mapped
    }

    /**
     * @param value Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
     */
    @JvmName("xcrhohtyjnqpyvtb")
    public suspend fun nodeResizeStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeResizeStrategy = mapped
    }

    /**
     * @param value Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
     */
    @JvmName("eatrkfioirbgkjqy")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
     */
    @JvmName("ctaaaxrprmmjafmu")
    public suspend fun spotBidPrices(`value`: List<ClusterNodeGroupSpotBidPriceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotBidPrices = mapped
    }

    /**
     * @param argument The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
     */
    @JvmName("esrpjmbjsfaggtgp")
    public suspend fun spotBidPrices(argument: List<suspend ClusterNodeGroupSpotBidPriceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupSpotBidPriceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotBidPrices = mapped
    }

    /**
     * @param argument The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
     */
    @JvmName("usikemoykhdelhjx")
    public suspend fun spotBidPrices(vararg argument: suspend ClusterNodeGroupSpotBidPriceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupSpotBidPriceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.spotBidPrices = mapped
    }

    /**
     * @param argument The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
     */
    @JvmName("dbcjtmkgesrbmcui")
    public suspend fun spotBidPrices(argument: suspend ClusterNodeGroupSpotBidPriceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterNodeGroupSpotBidPriceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.spotBidPrices = mapped
    }

    /**
     * @param values The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
     */
    @JvmName("uwdrpaydmwsbdooa")
    public suspend fun spotBidPrices(vararg values: ClusterNodeGroupSpotBidPriceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spotBidPrices = mapped
    }

    /**
     * @param value Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
     */
    @JvmName("eascdiyqhxtulcrw")
    public suspend fun spotInstanceRemedy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstanceRemedy = mapped
    }

    /**
     * @param value The detail configuration of subscription payment type. See `subscription_config` below.
     */
    @JvmName("yfshxlxysdiwvief")
    public suspend fun subscriptionConfig(`value`: ClusterNodeGroupSubscriptionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionConfig = mapped
    }

    /**
     * @param argument The detail configuration of subscription payment type. See `subscription_config` below.
     */
    @JvmName("kgqjuhqeanfxuvbe")
    public suspend fun subscriptionConfig(argument: suspend ClusterNodeGroupSubscriptionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterNodeGroupSubscriptionConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.subscriptionConfig = mapped
    }

    /**
     * @param value Host Ecs system disk information in this node group. See `system_disk` below.
     */
    @JvmName("fdgqkuhxjvddfepo")
    public suspend fun systemDisk(`value`: ClusterNodeGroupSystemDiskArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemDisk = mapped
    }

    /**
     * @param argument Host Ecs system disk information in this node group. See `system_disk` below.
     */
    @JvmName("aarsqluwtoiaypho")
    public suspend fun systemDisk(argument: suspend ClusterNodeGroupSystemDiskArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterNodeGroupSystemDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemDisk = mapped
    }

    /**
     * @param value Global vSwitch ids, you can also specify it in node group.
     */
    @JvmName("gqmjjghkheroqscq")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values Global vSwitch ids, you can also specify it in node group.
     */
    @JvmName("vtvbworrqrlnxcoe")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param value Whether the node has a public IP address enabled.
     */
    @JvmName("qmstjvppvrrufapn")
    public suspend fun withPublicIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withPublicIp = mapped
    }

    internal fun build(): ClusterNodeGroupArgs = ClusterNodeGroupArgs(
        additionalSecurityGroupIds = additionalSecurityGroupIds,
        autoScalingPolicy = autoScalingPolicy,
        costOptimizedConfig = costOptimizedConfig,
        dataDisks = dataDisks ?: throw PulumiNullFieldException("dataDisks"),
        deploymentSetStrategy = deploymentSetStrategy,
        gracefulShutdown = gracefulShutdown,
        instanceTypes = instanceTypes ?: throw PulumiNullFieldException("instanceTypes"),
        nodeCount = nodeCount ?: throw PulumiNullFieldException("nodeCount"),
        nodeGroupName = nodeGroupName ?: throw PulumiNullFieldException("nodeGroupName"),
        nodeGroupType = nodeGroupType ?: throw PulumiNullFieldException("nodeGroupType"),
        nodeResizeStrategy = nodeResizeStrategy,
        paymentType = paymentType,
        spotBidPrices = spotBidPrices,
        spotInstanceRemedy = spotInstanceRemedy,
        subscriptionConfig = subscriptionConfig,
        systemDisk = systemDisk ?: throw PulumiNullFieldException("systemDisk"),
        vswitchIds = vswitchIds,
        withPublicIp = withPublicIp,
    )
}
