@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property constraints The constraints of auto scaling policy. See `constraints` below.
 * @property scalingRules The scaling rules of auto scaling policy. See `scaling_rules` below.
 */
public data class ClusterNodeGroupAutoScalingPolicyArgs(
    public val constraints: Output<ClusterNodeGroupAutoScalingPolicyConstraintsArgs>? = null,
    public val scalingRules: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyArgs.builder()
            .constraints(constraints?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scalingRules(
                scalingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyArgsBuilder internal constructor() {
    private var constraints: Output<ClusterNodeGroupAutoScalingPolicyConstraintsArgs>? = null

    private var scalingRules: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleArgs>>? = null

    /**
     * @param value The constraints of auto scaling policy. See `constraints` below.
     */
    @JvmName("texkwlvliwcnqlpc")
    public suspend fun constraints(`value`: Output<ClusterNodeGroupAutoScalingPolicyConstraintsArgs>) {
        this.constraints = value
    }

    /**
     * @param value The scaling rules of auto scaling policy. See `scaling_rules` below.
     */
    @JvmName("vxifcsuggodykvuj")
    public suspend fun scalingRules(`value`: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleArgs>>) {
        this.scalingRules = value
    }

    @JvmName("gdevgteecvfirfaj")
    public suspend fun scalingRules(vararg values: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleArgs>) {
        this.scalingRules = Output.all(values.asList())
    }

    /**
     * @param values The scaling rules of auto scaling policy. See `scaling_rules` below.
     */
    @JvmName("utnoogwqrvhfyogp")
    public suspend fun scalingRules(values: List<Output<ClusterNodeGroupAutoScalingPolicyScalingRuleArgs>>) {
        this.scalingRules = Output.all(values)
    }

    /**
     * @param value The constraints of auto scaling policy. See `constraints` below.
     */
    @JvmName("uqspoyyljayhhxff")
    public suspend fun constraints(`value`: ClusterNodeGroupAutoScalingPolicyConstraintsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constraints = mapped
    }

    /**
     * @param argument The constraints of auto scaling policy. See `constraints` below.
     */
    @JvmName("cihqiqlcjyuekmyn")
    public suspend fun constraints(argument: suspend ClusterNodeGroupAutoScalingPolicyConstraintsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterNodeGroupAutoScalingPolicyConstraintsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.constraints = mapped
    }

    /**
     * @param value The scaling rules of auto scaling policy. See `scaling_rules` below.
     */
    @JvmName("jrqfcikcffbxpgrv")
    public suspend fun scalingRules(`value`: List<ClusterNodeGroupAutoScalingPolicyScalingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingRules = mapped
    }

    /**
     * @param argument The scaling rules of auto scaling policy. See `scaling_rules` below.
     */
    @JvmName("jukjjbiclfxdfnkj")
    public suspend fun scalingRules(argument: List<suspend ClusterNodeGroupAutoScalingPolicyScalingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingRules = mapped
    }

    /**
     * @param argument The scaling rules of auto scaling policy. See `scaling_rules` below.
     */
    @JvmName("qaqkdpadlmvjmkeg")
    public suspend fun scalingRules(vararg argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingRules = mapped
    }

    /**
     * @param argument The scaling rules of auto scaling policy. See `scaling_rules` below.
     */
    @JvmName("qyeflhpeiqjkobxf")
    public suspend fun scalingRules(argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterNodeGroupAutoScalingPolicyScalingRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.scalingRules = mapped
    }

    /**
     * @param values The scaling rules of auto scaling policy. See `scaling_rules` below.
     */
    @JvmName("urifoooqydeujmwv")
    public suspend fun scalingRules(vararg values: ClusterNodeGroupAutoScalingPolicyScalingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingRules = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyArgs =
        ClusterNodeGroupAutoScalingPolicyArgs(
            constraints = constraints,
            scalingRules = scalingRules,
        )
}
