@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyConstraintsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxCapacity The maximum capacity of constraints for emr node group auto scaling policy.
 * @property minCapacity The minimum capacity of constraints for emr node group auto scaling policy.
 */
public data class ClusterNodeGroupAutoScalingPolicyConstraintsArgs(
    public val maxCapacity: Output<Int>? = null,
    public val minCapacity: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyConstraintsArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyConstraintsArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyConstraintsArgs.builder()
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyConstraintsArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyConstraintsArgsBuilder internal constructor() {
    private var maxCapacity: Output<Int>? = null

    private var minCapacity: Output<Int>? = null

    /**
     * @param value The maximum capacity of constraints for emr node group auto scaling policy.
     */
    @JvmName("hklveyjbfyxivjhc")
    public suspend fun maxCapacity(`value`: Output<Int>) {
        this.maxCapacity = value
    }

    /**
     * @param value The minimum capacity of constraints for emr node group auto scaling policy.
     */
    @JvmName("oheyplprpxdpldoy")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value The maximum capacity of constraints for emr node group auto scaling policy.
     */
    @JvmName("kempkngvskbmmsag")
    public suspend fun maxCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value The minimum capacity of constraints for emr node group auto scaling policy.
     */
    @JvmName("cmgwrhwqfwpotgaj")
    public suspend fun minCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyConstraintsArgs =
        ClusterNodeGroupAutoScalingPolicyConstraintsArgs(
            maxCapacity = maxCapacity,
            minCapacity = minCapacity,
        )
}
