@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property activityType The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
 * @property adjustmentType The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
 * @property adjustmentValue The adjustment value of auto scaling policy. The value should between 1 and 5000.
 * @property metricsTrigger The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
 * @property minAdjustmentValue The minimum adjustment value of auto scaling policy.
 * @property ruleName The rule name of auto scaling policy.
 * @property timeTrigger The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
 * @property triggerType The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleArgs(
    public val activityType: Output<String>,
    public val adjustmentType: Output<String>? = null,
    public val adjustmentValue: Output<Int>,
    public val metricsTrigger: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs>? =
        null,
    public val minAdjustmentValue: Output<Int>? = null,
    public val ruleName: Output<String>,
    public val timeTrigger: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs>? =
        null,
    public val triggerType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleArgs.builder()
            .activityType(activityType.applyValue({ args0 -> args0 }))
            .adjustmentType(adjustmentType?.applyValue({ args0 -> args0 }))
            .adjustmentValue(adjustmentValue.applyValue({ args0 -> args0 }))
            .metricsTrigger(metricsTrigger?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .minAdjustmentValue(minAdjustmentValue?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName.applyValue({ args0 -> args0 }))
            .timeTrigger(timeTrigger?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .triggerType(triggerType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyScalingRuleArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyScalingRuleArgsBuilder internal constructor() {
    private var activityType: Output<String>? = null

    private var adjustmentType: Output<String>? = null

    private var adjustmentValue: Output<Int>? = null

    private var metricsTrigger:
        Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs>? = null

    private var minAdjustmentValue: Output<Int>? = null

    private var ruleName: Output<String>? = null

    private var timeTrigger: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs>? =
        null

    private var triggerType: Output<String>? = null

    /**
     * @param value The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
     */
    @JvmName("dwuesjtpjjwaijiu")
    public suspend fun activityType(`value`: Output<String>) {
        this.activityType = value
    }

    /**
     * @param value The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
     */
    @JvmName("iotcwgblkvdlvygd")
    public suspend fun adjustmentType(`value`: Output<String>) {
        this.adjustmentType = value
    }

    /**
     * @param value The adjustment value of auto scaling policy. The value should between 1 and 5000.
     */
    @JvmName("liuokwyqgntcvoqo")
    public suspend fun adjustmentValue(`value`: Output<Int>) {
        this.adjustmentValue = value
    }

    /**
     * @param value The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
     */
    @JvmName("iqffaddgfwptymsi")
    public suspend fun metricsTrigger(`value`: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs>) {
        this.metricsTrigger = value
    }

    /**
     * @param value The minimum adjustment value of auto scaling policy.
     */
    @JvmName("iistwtscnafiemqc")
    public suspend fun minAdjustmentValue(`value`: Output<Int>) {
        this.minAdjustmentValue = value
    }

    /**
     * @param value The rule name of auto scaling policy.
     */
    @JvmName("wogvigscxmnrneyf")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
     */
    @JvmName("jicdhpoupsbhydri")
    public suspend fun timeTrigger(`value`: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs>) {
        this.timeTrigger = value
    }

    /**
     * @param value The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
     */
    @JvmName("mbhpmodffcckcxpc")
    public suspend fun triggerType(`value`: Output<String>) {
        this.triggerType = value
    }

    /**
     * @param value The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
     */
    @JvmName("laddkfgdtjtagyut")
    public suspend fun activityType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activityType = mapped
    }

    /**
     * @param value The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
     */
    @JvmName("phyhuuctjehxvemu")
    public suspend fun adjustmentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adjustmentType = mapped
    }

    /**
     * @param value The adjustment value of auto scaling policy. The value should between 1 and 5000.
     */
    @JvmName("vdxgllqbtqyldbrd")
    public suspend fun adjustmentValue(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adjustmentValue = mapped
    }

    /**
     * @param value The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
     */
    @JvmName("jttdphvctkcfugwk")
    public suspend fun metricsTrigger(`value`: ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsTrigger = mapped
    }

    /**
     * @param argument The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
     */
    @JvmName("geylxxbwnartetdg")
    public suspend fun metricsTrigger(argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.metricsTrigger = mapped
    }

    /**
     * @param value The minimum adjustment value of auto scaling policy.
     */
    @JvmName("wwrvntittullwtcv")
    public suspend fun minAdjustmentValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minAdjustmentValue = mapped
    }

    /**
     * @param value The rule name of auto scaling policy.
     */
    @JvmName("ydlbsevdkkesjqiy")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
     */
    @JvmName("fhmfpqdjslwwgxoe")
    public suspend fun timeTrigger(`value`: ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeTrigger = mapped
    }

    /**
     * @param argument The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
     */
    @JvmName("kmfymtikjqtannqk")
    public suspend fun timeTrigger(argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeTrigger = mapped
    }

    /**
     * @param value The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
     */
    @JvmName("ubbituykrikqvemi")
    public suspend fun triggerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyScalingRuleArgs =
        ClusterNodeGroupAutoScalingPolicyScalingRuleArgs(
            activityType = activityType ?: throw PulumiNullFieldException("activityType"),
            adjustmentType = adjustmentType,
            adjustmentValue = adjustmentValue ?: throw PulumiNullFieldException("adjustmentValue"),
            metricsTrigger = metricsTrigger,
            minAdjustmentValue = minAdjustmentValue,
            ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
            timeTrigger = timeTrigger,
            triggerType = triggerType ?: throw PulumiNullFieldException("triggerType"),
        )
}
