@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property conditionLogicOperator The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
 * @property conditions The conditions for this scaling rule specific metrics trigger. See `conditions` below.
 * @property coolDownInterval The time of cool down interval for this scaling rule specific metrics trigger.
 * @property evaluationCount The evaluation count for this scaling rule specific metrics trigger.
 * @property timeConstraints The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
 * @property timeWindow The time window for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs(
    public val conditionLogicOperator: Output<String>? = null,
    public val conditions: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs>>? = null,
    public val coolDownInterval: Output<Int>? = null,
    public val evaluationCount: Output<Int>,
    public val timeConstraints: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs>>? =
        null,
    public val timeWindow: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs.builder()
            .conditionLogicOperator(conditionLogicOperator?.applyValue({ args0 -> args0 }))
            .conditions(
                conditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .coolDownInterval(coolDownInterval?.applyValue({ args0 -> args0 }))
            .evaluationCount(evaluationCount.applyValue({ args0 -> args0 }))
            .timeConstraints(
                timeConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeWindow(timeWindow.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgsBuilder internal constructor() {
    private var conditionLogicOperator: Output<String>? = null

    private var conditions:
        Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs>>? = null

    private var coolDownInterval: Output<Int>? = null

    private var evaluationCount: Output<Int>? = null

    private var timeConstraints:
        Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs>>? =
        null

    private var timeWindow: Output<Int>? = null

    /**
     * @param value The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
     */
    @JvmName("tfvnalsqdrrtttai")
    public suspend fun conditionLogicOperator(`value`: Output<String>) {
        this.conditionLogicOperator = value
    }

    /**
     * @param value The conditions for this scaling rule specific metrics trigger. See `conditions` below.
     */
    @JvmName("vobamwjhnodcuxkf")
    public suspend fun conditions(`value`: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("mecfueriboyciitc")
    public suspend fun conditions(vararg values: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values The conditions for this scaling rule specific metrics trigger. See `conditions` below.
     */
    @JvmName("impxvjdwpjpggxqh")
    public suspend fun conditions(values: List<Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value The time of cool down interval for this scaling rule specific metrics trigger.
     */
    @JvmName("wuxmhjwyndykjtuf")
    public suspend fun coolDownInterval(`value`: Output<Int>) {
        this.coolDownInterval = value
    }

    /**
     * @param value The evaluation count for this scaling rule specific metrics trigger.
     */
    @JvmName("raiemkorqtbpfsyy")
    public suspend fun evaluationCount(`value`: Output<Int>) {
        this.evaluationCount = value
    }

    /**
     * @param value The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
     */
    @JvmName("efvpfrgiwuukibhf")
    public suspend fun timeConstraints(`value`: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs>>) {
        this.timeConstraints = value
    }

    @JvmName("csvoqrlnqikotsqm")
    public suspend fun timeConstraints(vararg values: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs>) {
        this.timeConstraints = Output.all(values.asList())
    }

    /**
     * @param values The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
     */
    @JvmName("bkinqmegxggclrfn")
    public suspend fun timeConstraints(values: List<Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs>>) {
        this.timeConstraints = Output.all(values)
    }

    /**
     * @param value The time window for this scaling rule specific metrics trigger.
     */
    @JvmName("uflntjtxukprydjc")
    public suspend fun timeWindow(`value`: Output<Int>) {
        this.timeWindow = value
    }

    /**
     * @param value The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
     */
    @JvmName("cmqosrijvmxneqmu")
    public suspend fun conditionLogicOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionLogicOperator = mapped
    }

    /**
     * @param value The conditions for this scaling rule specific metrics trigger. See `conditions` below.
     */
    @JvmName("dbjgfxwgmaflknij")
    public suspend fun conditions(`value`: List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument The conditions for this scaling rule specific metrics trigger. See `conditions` below.
     */
    @JvmName("lgsgenvfpplbwrhw")
    public suspend fun conditions(argument: List<suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument The conditions for this scaling rule specific metrics trigger. See `conditions` below.
     */
    @JvmName("yqbybcsattxgcivn")
    public suspend fun conditions(vararg argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument The conditions for this scaling rule specific metrics trigger. See `conditions` below.
     */
    @JvmName("wernepjdhogwshvd")
    public suspend fun conditions(argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values The conditions for this scaling rule specific metrics trigger. See `conditions` below.
     */
    @JvmName("wnmgywdpyiofdtcc")
    public suspend fun conditions(vararg values: ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value The time of cool down interval for this scaling rule specific metrics trigger.
     */
    @JvmName("ppumhcpjyqjbipri")
    public suspend fun coolDownInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolDownInterval = mapped
    }

    /**
     * @param value The evaluation count for this scaling rule specific metrics trigger.
     */
    @JvmName("cimrogwcmawaryyv")
    public suspend fun evaluationCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evaluationCount = mapped
    }

    /**
     * @param value The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
     */
    @JvmName("vemdtgmmrdhjrxxw")
    public suspend fun timeConstraints(`value`: List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeConstraints = mapped
    }

    /**
     * @param argument The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
     */
    @JvmName("mldrlpekvmdjfcnw")
    public suspend fun timeConstraints(argument: List<suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timeConstraints = mapped
    }

    /**
     * @param argument The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
     */
    @JvmName("mogdtbjhvxqjicvr")
    public suspend fun timeConstraints(vararg argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.timeConstraints = mapped
    }

    /**
     * @param argument The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
     */
    @JvmName("dffkvdyakicgyocf")
    public suspend fun timeConstraints(argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.timeConstraints = mapped
    }

    /**
     * @param values The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
     */
    @JvmName("rmctdoktebannkki")
    public suspend fun timeConstraints(vararg values: ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeConstraints = mapped
    }

    /**
     * @param value The time window for this scaling rule specific metrics trigger.
     */
    @JvmName("obitghosruxftjea")
    public suspend fun timeWindow(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeWindow = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs =
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerArgs(
            conditionLogicOperator = conditionLogicOperator,
            conditions = conditions,
            coolDownInterval = coolDownInterval,
            evaluationCount = evaluationCount ?: throw PulumiNullFieldException("evaluationCount"),
            timeConstraints = timeConstraints,
            timeWindow = timeWindow ?: throw PulumiNullFieldException("timeWindow"),
        )
}
