@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
 * @property metricName The metric name for this scaling rule specific metrics trigger.
 * @property statistics The statistics for this scaling rule specific metrics trigger.
 * @property tags A mapping of tags to assign to the resource.
 * @property threshold The threshold for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs(
    public val comparisonOperator: Output<String>,
    public val metricName: Output<String>,
    public val statistics: Output<String>,
    public val tags: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs>>? =
        null,
    public val threshold: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs.builder()
            .comparisonOperator(comparisonOperator.applyValue({ args0 -> args0 }))
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .statistics(statistics.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .threshold(threshold.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var metricName: Output<String>? = null

    private var statistics: Output<String>? = null

    private var tags:
        Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs>>? =
        null

    private var threshold: Output<Double>? = null

    /**
     * @param value The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
     */
    @JvmName("qvgkitpwggtatbtq")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value The metric name for this scaling rule specific metrics trigger.
     */
    @JvmName("somqwqopsoyoxrlw")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The statistics for this scaling rule specific metrics trigger.
     */
    @JvmName("twugwbfamcoviflt")
    public suspend fun statistics(`value`: Output<String>) {
        this.statistics = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("upxggkbvmvxmkxkt")
    public suspend fun tags(`value`: Output<List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs>>) {
        this.tags = value
    }

    @JvmName("tmhollrqsolntfon")
    public suspend fun tags(vararg values: Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("wnhwoannhsvcydjr")
    public suspend fun tags(values: List<Output<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value The threshold for this scaling rule specific metrics trigger.
     */
    @JvmName("jbwogdlrwlmtuwfs")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
     */
    @JvmName("xhtaixlqaqpkdhgx")
    public suspend fun comparisonOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value The metric name for this scaling rule specific metrics trigger.
     */
    @JvmName("wmipmartbwkpjrmy")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The statistics for this scaling rule specific metrics trigger.
     */
    @JvmName("opinvqhcuacgaypk")
    public suspend fun statistics(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("donwufoygnbxjvqd")
    public suspend fun tags(`value`: List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument A mapping of tags to assign to the resource.
     */
    @JvmName("hylormhfecvfahdb")
    public suspend fun tags(argument: List<suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument A mapping of tags to assign to the resource.
     */
    @JvmName("cfelekecwvictrqb")
    public suspend fun tags(vararg argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument A mapping of tags to assign to the resource.
     */
    @JvmName("cfxyggiujftwrojr")
    public suspend fun tags(argument: suspend ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("iscrftdvaxxivaan")
    public suspend fun tags(vararg values: ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The threshold for this scaling rule specific metrics trigger.
     */
    @JvmName("iywsgxgetxauuasi")
    public suspend fun threshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs =
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionArgs(
            comparisonOperator = comparisonOperator ?: throw PulumiNullFieldException("comparisonOperator"),
            metricName = metricName ?: throw PulumiNullFieldException("metricName"),
            statistics = statistics ?: throw PulumiNullFieldException("statistics"),
            tags = tags,
            threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        )
}
