@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The tag key for this scaling rule specific metrics trigger.
 * @property value The tag value for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs(
    public val key: Output<String>,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgsBuilder
internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The tag key for this scaling rule specific metrics trigger.
     */
    @JvmName("blyelejwklcwnwai")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The tag value for this scaling rule specific metrics trigger.
     */
    @JvmName("wlqglrdpjfhpmwbh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The tag key for this scaling rule specific metrics trigger.
     */
    @JvmName("eiammbtgxpokehyb")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The tag value for this scaling rule specific metrics trigger.
     */
    @JvmName("cxltlawfetruklkp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs =
        ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTagArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value`,
        )
}
