@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endTime The end time for this scaling rule specific metrics trigger.
 * @property startTime The start time for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs(
    public val endTime: Output<String>? = null,
    public val startTime: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs.builder()
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgsBuilder
internal constructor() {
    private var endTime: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value The end time for this scaling rule specific metrics trigger.
     */
    @JvmName("qajwbjseklmyvkjg")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The start time for this scaling rule specific metrics trigger.
     */
    @JvmName("nghlwcmwnuupnytm")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The end time for this scaling rule specific metrics trigger.
     */
    @JvmName("iulcpchwnsbbvxse")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The start time for this scaling rule specific metrics trigger.
     */
    @JvmName("apoaycfttbonlexd")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs = ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraintArgs(
        endTime = endTime,
        startTime = startTime,
    )
}
