@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endTime The end time for this scaling rule specific metrics trigger.
 * @property launchExpirationTime The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
 * @property launchTime The launch time for this scaling rule specific time trigger.
 * @property recurrenceType The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
 * @property recurrenceValue The recurrence value for this scaling rule specific time trigger.
 * @property startTime The start time for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs(
    public val endTime: Output<String>? = null,
    public val launchExpirationTime: Output<Int>? = null,
    public val launchTime: Output<String>,
    public val recurrenceType: Output<String>? = null,
    public val recurrenceValue: Output<String>? = null,
    public val startTime: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs.builder()
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .launchExpirationTime(launchExpirationTime?.applyValue({ args0 -> args0 }))
            .launchTime(launchTime.applyValue({ args0 -> args0 }))
            .recurrenceType(recurrenceType?.applyValue({ args0 -> args0 }))
            .recurrenceValue(recurrenceValue?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgsBuilder internal constructor() {
    private var endTime: Output<String>? = null

    private var launchExpirationTime: Output<Int>? = null

    private var launchTime: Output<String>? = null

    private var recurrenceType: Output<String>? = null

    private var recurrenceValue: Output<String>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value The end time for this scaling rule specific metrics trigger.
     */
    @JvmName("mmmyyxoscigmmihq")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
     */
    @JvmName("kvfhdilwtwlqtcxh")
    public suspend fun launchExpirationTime(`value`: Output<Int>) {
        this.launchExpirationTime = value
    }

    /**
     * @param value The launch time for this scaling rule specific time trigger.
     */
    @JvmName("qtghiypgfeottpfa")
    public suspend fun launchTime(`value`: Output<String>) {
        this.launchTime = value
    }

    /**
     * @param value The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
     */
    @JvmName("tgvselgqgihiomjw")
    public suspend fun recurrenceType(`value`: Output<String>) {
        this.recurrenceType = value
    }

    /**
     * @param value The recurrence value for this scaling rule specific time trigger.
     */
    @JvmName("esoajjdocaecfoii")
    public suspend fun recurrenceValue(`value`: Output<String>) {
        this.recurrenceValue = value
    }

    /**
     * @param value The start time for this scaling rule specific metrics trigger.
     */
    @JvmName("nadjosdosoosllui")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The end time for this scaling rule specific metrics trigger.
     */
    @JvmName("bgeenbbeihxenity")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
     */
    @JvmName("vkgaqlndnhjmfsnv")
    public suspend fun launchExpirationTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchExpirationTime = mapped
    }

    /**
     * @param value The launch time for this scaling rule specific time trigger.
     */
    @JvmName("tlkthrangyjqjsnr")
    public suspend fun launchTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTime = mapped
    }

    /**
     * @param value The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
     */
    @JvmName("hycymawrxvsdwqyy")
    public suspend fun recurrenceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value The recurrence value for this scaling rule specific time trigger.
     */
    @JvmName("qjtwtonmbmmiaaij")
    public suspend fun recurrenceValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceValue = mapped
    }

    /**
     * @param value The start time for this scaling rule specific metrics trigger.
     */
    @JvmName("sdlaojmfrgaottyd")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs =
        ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTriggerArgs(
            endTime = endTime,
            launchExpirationTime = launchExpirationTime,
            launchTime = launchTime ?: throw PulumiNullFieldException("launchTime"),
            recurrenceType = recurrenceType,
            recurrenceValue = recurrenceValue,
            startTime = startTime,
        )
}
