@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupCostOptimizedConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property onDemandBaseCapacity The cost optimized configuration which on demand based capacity.
 * @property onDemandPercentageAboveBaseCapacity The cost optimized configuration which on demand percentage above based capacity.
 * @property spotInstancePools The cost optimized configuration with spot instance pools.
 */
public data class ClusterNodeGroupCostOptimizedConfigArgs(
    public val onDemandBaseCapacity: Output<Int>,
    public val onDemandPercentageAboveBaseCapacity: Output<Int>,
    public val spotInstancePools: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupCostOptimizedConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupCostOptimizedConfigArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupCostOptimizedConfigArgs.builder()
            .onDemandBaseCapacity(onDemandBaseCapacity.applyValue({ args0 -> args0 }))
            .onDemandPercentageAboveBaseCapacity(
                onDemandPercentageAboveBaseCapacity.applyValue({ args0 ->
                    args0
                }),
            )
            .spotInstancePools(spotInstancePools.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupCostOptimizedConfigArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupCostOptimizedConfigArgsBuilder internal constructor() {
    private var onDemandBaseCapacity: Output<Int>? = null

    private var onDemandPercentageAboveBaseCapacity: Output<Int>? = null

    private var spotInstancePools: Output<Int>? = null

    /**
     * @param value The cost optimized configuration which on demand based capacity.
     */
    @JvmName("ltlqodfbcpoqsfqf")
    public suspend fun onDemandBaseCapacity(`value`: Output<Int>) {
        this.onDemandBaseCapacity = value
    }

    /**
     * @param value The cost optimized configuration which on demand percentage above based capacity.
     */
    @JvmName("pmiakrpcepcbyyra")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Output<Int>) {
        this.onDemandPercentageAboveBaseCapacity = value
    }

    /**
     * @param value The cost optimized configuration with spot instance pools.
     */
    @JvmName("xaqhjmwabajoriop")
    public suspend fun spotInstancePools(`value`: Output<Int>) {
        this.spotInstancePools = value
    }

    /**
     * @param value The cost optimized configuration which on demand based capacity.
     */
    @JvmName("ectuhtixeetenflt")
    public suspend fun onDemandBaseCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDemandBaseCapacity = mapped
    }

    /**
     * @param value The cost optimized configuration which on demand percentage above based capacity.
     */
    @JvmName("fiitchbuwedlrpjj")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDemandPercentageAboveBaseCapacity = mapped
    }

    /**
     * @param value The cost optimized configuration with spot instance pools.
     */
    @JvmName("tdumtvbvxwfekkex")
    public suspend fun spotInstancePools(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spotInstancePools = mapped
    }

    internal fun build(): ClusterNodeGroupCostOptimizedConfigArgs =
        ClusterNodeGroupCostOptimizedConfigArgs(
            onDemandBaseCapacity = onDemandBaseCapacity ?: throw
                PulumiNullFieldException("onDemandBaseCapacity"),
            onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity ?: throw
                PulumiNullFieldException("onDemandPercentageAboveBaseCapacity"),
            spotInstancePools = spotInstancePools ?: throw PulumiNullFieldException("spotInstancePools"),
        )
}
