@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSpotBidPriceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bidPrice The spot bid price of a PayAsYouGo instance.
 * @property instanceType Host Ecs instance type.
 */
public data class ClusterNodeGroupSpotBidPriceArgs(
    public val bidPrice: Output<Int>,
    public val instanceType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSpotBidPriceArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSpotBidPriceArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSpotBidPriceArgs.builder()
            .bidPrice(bidPrice.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupSpotBidPriceArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupSpotBidPriceArgsBuilder internal constructor() {
    private var bidPrice: Output<Int>? = null

    private var instanceType: Output<String>? = null

    /**
     * @param value The spot bid price of a PayAsYouGo instance.
     */
    @JvmName("ujiagilbxnmdligd")
    public suspend fun bidPrice(`value`: Output<Int>) {
        this.bidPrice = value
    }

    /**
     * @param value Host Ecs instance type.
     */
    @JvmName("kbnleebbvkkcsytj")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The spot bid price of a PayAsYouGo instance.
     */
    @JvmName("baomkborkjsaygqt")
    public suspend fun bidPrice(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bidPrice = mapped
    }

    /**
     * @param value Host Ecs instance type.
     */
    @JvmName("bgtobkacrgfjxmod")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): ClusterNodeGroupSpotBidPriceArgs = ClusterNodeGroupSpotBidPriceArgs(
        bidPrice = bidPrice ?: throw PulumiNullFieldException("bidPrice"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
    )
}
