@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSystemDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
 * @property count The count of a data disk.
 * @property performanceLevel Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
 * @property size The size of a data disk, at least 40. Unit: GiB.
 */
public data class ClusterNodeGroupSystemDiskArgs(
    public val category: Output<String>,
    public val count: Output<Int>? = null,
    public val performanceLevel: Output<String>? = null,
    public val size: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSystemDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSystemDiskArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterNodeGroupSystemDiskArgs.builder()
            .category(category.applyValue({ args0 -> args0 }))
            .count(count?.applyValue({ args0 -> args0 }))
            .performanceLevel(performanceLevel?.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterNodeGroupSystemDiskArgs].
 */
@PulumiTagMarker
public class ClusterNodeGroupSystemDiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var count: Output<Int>? = null

    private var performanceLevel: Output<String>? = null

    private var size: Output<Int>? = null

    /**
     * @param value The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
     */
    @JvmName("qxlcudakypsgfopd")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The count of a data disk.
     */
    @JvmName("ghmeyscudsgkxkci")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
     */
    @JvmName("mlvtmsfxblfkujwy")
    public suspend fun performanceLevel(`value`: Output<String>) {
        this.performanceLevel = value
    }

    /**
     * @param value The size of a data disk, at least 40. Unit: GiB.
     */
    @JvmName("keepnvwtaqydxsjh")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
     */
    @JvmName("nbqkjepqiisaetkq")
    public suspend fun category(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The count of a data disk.
     */
    @JvmName("jboqjjaeuibyabwc")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
     */
    @JvmName("pgmmwjqywxqsydfw")
    public suspend fun performanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceLevel = mapped
    }

    /**
     * @param value The size of a data disk, at least 40. Unit: GiB.
     */
    @JvmName("hshrtrajtmhlbjup")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): ClusterNodeGroupSystemDiskArgs = ClusterNodeGroupSystemDiskArgs(
        category = category ?: throw PulumiNullFieldException("category"),
        count = count,
        performanceLevel = performanceLevel,
        size = size ?: throw PulumiNullFieldException("size"),
    )
}
