@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.ClusterSubscriptionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoPayOrder Auto pay order for payment type of subscription, ’true’ or ‘false’ .
 * @property autoRenew Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
 * @property autoRenewDuration If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
 * @property autoRenewDurationUnit If paymentType is Subscription, this should be specified. Supported value: Month or Year.
 * @property paymentDuration If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
 * @property paymentDurationUnit If paymentType is Subscription, this should be specified. Supported value: Month or Year.
 */
public data class ClusterSubscriptionConfigArgs(
    public val autoPayOrder: Output<Boolean>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewDuration: Output<Int>? = null,
    public val autoRenewDurationUnit: Output<String>? = null,
    public val paymentDuration: Output<Int>,
    public val paymentDurationUnit: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.ClusterSubscriptionConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.ClusterSubscriptionConfigArgs =
        com.pulumi.alicloud.emrv2.inputs.ClusterSubscriptionConfigArgs.builder()
            .autoPayOrder(autoPayOrder?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewDuration(autoRenewDuration?.applyValue({ args0 -> args0 }))
            .autoRenewDurationUnit(autoRenewDurationUnit?.applyValue({ args0 -> args0 }))
            .paymentDuration(paymentDuration.applyValue({ args0 -> args0 }))
            .paymentDurationUnit(paymentDurationUnit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterSubscriptionConfigArgs].
 */
@PulumiTagMarker
public class ClusterSubscriptionConfigArgsBuilder internal constructor() {
    private var autoPayOrder: Output<Boolean>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoRenewDuration: Output<Int>? = null

    private var autoRenewDurationUnit: Output<String>? = null

    private var paymentDuration: Output<Int>? = null

    private var paymentDurationUnit: Output<String>? = null

    /**
     * @param value Auto pay order for payment type of subscription, ’true’ or ‘false’ .
     */
    @JvmName("jmumiuoakxuuurvy")
    public suspend fun autoPayOrder(`value`: Output<Boolean>) {
        this.autoPayOrder = value
    }

    /**
     * @param value Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
     */
    @JvmName("xdxtccwxwwabubrl")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
     */
    @JvmName("hksnfenprbgspkrp")
    public suspend fun autoRenewDuration(`value`: Output<Int>) {
        this.autoRenewDuration = value
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: Month or Year.
     */
    @JvmName("ppgnlrfvldmrfuhq")
    public suspend fun autoRenewDurationUnit(`value`: Output<String>) {
        this.autoRenewDurationUnit = value
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
     */
    @JvmName("bnmqkxicicjnpydu")
    public suspend fun paymentDuration(`value`: Output<Int>) {
        this.paymentDuration = value
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: Month or Year.
     */
    @JvmName("rwhvdhvnxyehcqsr")
    public suspend fun paymentDurationUnit(`value`: Output<String>) {
        this.paymentDurationUnit = value
    }

    /**
     * @param value Auto pay order for payment type of subscription, ’true’ or ‘false’ .
     */
    @JvmName("sbojlymeeyhbjdev")
    public suspend fun autoPayOrder(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPayOrder = mapped
    }

    /**
     * @param value Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
     */
    @JvmName("npadcgviwkkabjgr")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
     */
    @JvmName("xgrloladjieeaavn")
    public suspend fun autoRenewDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewDuration = mapped
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: Month or Year.
     */
    @JvmName("xswkhksjfjrguppa")
    public suspend fun autoRenewDurationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewDurationUnit = mapped
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
     */
    @JvmName("fyxlwsgqicocvbjd")
    public suspend fun paymentDuration(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paymentDuration = mapped
    }

    /**
     * @param value If paymentType is Subscription, this should be specified. Supported value: Month or Year.
     */
    @JvmName("mpuvpblwfvxtsjcg")
    public suspend fun paymentDurationUnit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paymentDurationUnit = mapped
    }

    internal fun build(): ClusterSubscriptionConfigArgs = ClusterSubscriptionConfigArgs(
        autoPayOrder = autoPayOrder,
        autoRenew = autoRenew,
        autoRenewDuration = autoRenewDuration,
        autoRenewDurationUnit = autoRenewDurationUnit,
        paymentDuration = paymentDuration ?: throw PulumiNullFieldException("paymentDuration"),
        paymentDurationUnit = paymentDurationUnit ?: throw PulumiNullFieldException("paymentDurationUnit"),
    )
}
