@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.inputs

import com.pulumi.alicloud.emrv2.inputs.GetClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusters.
 * @property clusterName The cluster name.
 * @property clusterStates The cluster states.
 * @property clusterTypes The cluster types.
 * @property ids A list of Cluster IDS.
 * @property maxResults The max results is used to list clusters for next page.
 * @property nameRegex A regex string to filter results by Cluster name.
 * @property nextToken The next token is used to list clusters for next page.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property paymentTypes The cluster payment types.
 * @property resourceGroupId The Resource Group ID.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetClustersPlainArgs(
    public val clusterName: String? = null,
    public val clusterStates: List<String>? = null,
    public val clusterTypes: List<String>? = null,
    public val ids: List<String>? = null,
    public val maxResults: Int? = null,
    public val nameRegex: String? = null,
    public val nextToken: String? = null,
    public val outputFile: String? = null,
    public val paymentTypes: List<String>? = null,
    public val resourceGroupId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.emrv2.inputs.GetClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.emrv2.inputs.GetClustersPlainArgs =
        com.pulumi.alicloud.emrv2.inputs.GetClustersPlainArgs.builder()
            .clusterName(clusterName?.let({ args0 -> args0 }))
            .clusterStates(clusterStates?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterTypes(clusterTypes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxResults(maxResults?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .nextToken(nextToken?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .paymentTypes(paymentTypes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetClustersPlainArgs].
 */
@PulumiTagMarker
public class GetClustersPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var clusterStates: List<String>? = null

    private var clusterTypes: List<String>? = null

    private var ids: List<String>? = null

    private var maxResults: Int? = null

    private var nameRegex: String? = null

    private var nextToken: String? = null

    private var outputFile: String? = null

    private var paymentTypes: List<String>? = null

    private var resourceGroupId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The cluster name.
     */
    @JvmName("qmjwiqakmpskajpe")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The cluster states.
     */
    @JvmName("bwvawncdptxmlovh")
    public suspend fun clusterStates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterStates = mapped
    }

    /**
     * @param values The cluster states.
     */
    @JvmName("kusuwnnavvdxxeaq")
    public suspend fun clusterStates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterStates = mapped
    }

    /**
     * @param value The cluster types.
     */
    @JvmName("cawjcxqitlwggmby")
    public suspend fun clusterTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterTypes = mapped
    }

    /**
     * @param values The cluster types.
     */
    @JvmName("pkeyciyemclpqhxc")
    public suspend fun clusterTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterTypes = mapped
    }

    /**
     * @param value A list of Cluster IDS.
     */
    @JvmName("tgkbogbcalnjtgce")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Cluster IDS.
     */
    @JvmName("dpvwnlgfwnhmmmwv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The max results is used to list clusters for next page.
     */
    @JvmName("boahyxdrrcitokru")
    public suspend fun maxResults(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxResults = mapped
    }

    /**
     * @param value A regex string to filter results by Cluster name.
     */
    @JvmName("fvftcydesrfxkwbt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The next token is used to list clusters for next page.
     */
    @JvmName("jrghbeqwbsueyrbs")
    public suspend fun nextToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nextToken = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tvlmgcfheoqjgrtl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The cluster payment types.
     */
    @JvmName("ayvdmjxnfavpfmct")
    public suspend fun paymentTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.paymentTypes = mapped
    }

    /**
     * @param values The cluster payment types.
     */
    @JvmName("gqihawwxgsaantwy")
    public suspend fun paymentTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.paymentTypes = mapped
    }

    /**
     * @param value The Resource Group ID.
     */
    @JvmName("jxtningigcxfexun")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("tvjxjebncjnotark")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("tbustwqhbqlhudml")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetClustersPlainArgs = GetClustersPlainArgs(
        clusterName = clusterName,
        clusterStates = clusterStates,
        clusterTypes = clusterTypes,
        ids = ids,
        maxResults = maxResults,
        nameRegex = nameRegex,
        nextToken = nextToken,
        outputFile = outputFile,
        paymentTypes = paymentTypes,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
