@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationName The application name of EMR cluster which has installed.
 * @property configDescription The configuration description of application installed.
 * @property configFileName The configuration file name of application installed.
 * @property configItemKey The configuration item key of application installed.
 * @property configItemValue The configuration item value of application installed.
 * @property configScope The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
 * @property nodeGroupId The configuration effected which node group id of emr cluster.
 * @property nodeGroupName The configuration effected which node group name of emr cluster.
 */
public data class ClusterApplicationConfig(
    public val applicationName: String,
    public val configDescription: String? = null,
    public val configFileName: String,
    public val configItemKey: String,
    public val configItemValue: String,
    public val configScope: String? = null,
    public val nodeGroupId: String? = null,
    public val nodeGroupName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterApplicationConfig): ClusterApplicationConfig = ClusterApplicationConfig(
            applicationName = javaType.applicationName(),
            configDescription = javaType.configDescription().map({ args0 -> args0 }).orElse(null),
            configFileName = javaType.configFileName(),
            configItemKey = javaType.configItemKey(),
            configItemValue = javaType.configItemValue(),
            configScope = javaType.configScope().map({ args0 -> args0 }).orElse(null),
            nodeGroupId = javaType.nodeGroupId().map({ args0 -> args0 }).orElse(null),
            nodeGroupName = javaType.nodeGroupName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
