@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property executionFailStrategy The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
 * @property executionMoment The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
 * @property nodeSelector The bootstrap scripts execution target. See `node_selector` below.
 * @property priority The bootstrap scripts priority.
 * @property scriptArgs The bootstrap script args, e.g. "--a=b".
 * @property scriptName The bootstrap script name.
 * @property scriptPath The bootstrap script path, e.g. "oss://bucket/path".
 */
public data class ClusterBootstrapScript(
    public val executionFailStrategy: String,
    public val executionMoment: String,
    public val nodeSelector: ClusterBootstrapScriptNodeSelector,
    @Deprecated(
        message = """
  Field 'priority' has been deprecated from provider version 1.227.0.
  """,
    )
    public val priority: Int? = null,
    public val scriptArgs: String,
    public val scriptName: String,
    public val scriptPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterBootstrapScript): ClusterBootstrapScript = ClusterBootstrapScript(
            executionFailStrategy = javaType.executionFailStrategy(),
            executionMoment = javaType.executionMoment(),
            nodeSelector = javaType.nodeSelector().let({ args0 ->
                com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterBootstrapScriptNodeSelector.Companion.toKotlin(args0)
            }),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            scriptArgs = javaType.scriptArgs(),
            scriptName = javaType.scriptName(),
            scriptPath = javaType.scriptPath(),
        )
    }
}
