@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataDiskEncrypted Whether to enable data disk encryption.
 * @property dataDiskKmsKeyId The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
 * @property keyPairName The name of the key pair.
 * @property ramRole Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
 * @property securityGroupId Security Group ID for Cluster.
 * @property vpcId Used to retrieve instances belong to specified VPC.
 * @property zoneId Zone ID, e.g. cn-hangzhou-i
 */
public data class ClusterNodeAttribute(
    public val dataDiskEncrypted: Boolean? = null,
    public val dataDiskKmsKeyId: String? = null,
    public val keyPairName: String,
    public val ramRole: String,
    public val securityGroupId: String,
    public val vpcId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeAttribute): ClusterNodeAttribute = ClusterNodeAttribute(
            dataDiskEncrypted = javaType.dataDiskEncrypted().map({ args0 -> args0 }).orElse(null),
            dataDiskKmsKeyId = javaType.dataDiskKmsKeyId().map({ args0 -> args0 }).orElse(null),
            keyPairName = javaType.keyPairName(),
            ramRole = javaType.ramRole(),
            securityGroupId = javaType.securityGroupId(),
            vpcId = javaType.vpcId(),
            zoneId = javaType.zoneId(),
        )
    }
}
