@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalSecurityGroupIds Additional security Group IDS for Cluster, you can also specify this key for each node group.
 * @property autoScalingPolicy The node group auto scaling policy for emr cluster. See `auto_scaling_policy` below.
 * @property costOptimizedConfig The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
 * @property dataDisks Host Ecs data disks information in this node group. See `data_disks` below.
 * @property deploymentSetStrategy Deployment set strategy for this cluster node group. Supported value: NONE, CLUSTER or NODE_GROUP.
 * @property gracefulShutdown Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
 * @property instanceTypes Host Ecs instance types.
 * @property nodeCount Host Ecs number in this node group.
 * @property nodeGroupName The node group name of emr cluster.
 * @property nodeGroupType The node group type of emr cluster, supported value: MASTER, CORE or TASK. Node group type of GATEWAY is available since v1.219.0.
 * @property nodeResizeStrategy Node resize strategy for this cluster node group. Supported value: PRIORITY, COST_OPTIMIZED.
 * @property paymentType Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
 * @property spotBidPrices The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
 * @property spotInstanceRemedy Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
 * @property subscriptionConfig The detail configuration of subscription payment type. See `subscription_config` below.
 * @property systemDisk Host Ecs system disk information in this node group. See `system_disk` below.
 * @property vswitchIds Global vSwitch ids, you can also specify it in node group.
 * @property withPublicIp Whether the node has a public IP address enabled.
 */
public data class ClusterNodeGroup(
    public val additionalSecurityGroupIds: List<String>? = null,
    public val autoScalingPolicy: ClusterNodeGroupAutoScalingPolicy? = null,
    public val costOptimizedConfig: ClusterNodeGroupCostOptimizedConfig? = null,
    public val dataDisks: List<ClusterNodeGroupDataDisk>,
    public val deploymentSetStrategy: String? = null,
    public val gracefulShutdown: Boolean? = null,
    public val instanceTypes: List<String>,
    public val nodeCount: Int,
    public val nodeGroupName: String,
    public val nodeGroupType: String,
    public val nodeResizeStrategy: String? = null,
    public val paymentType: String? = null,
    public val spotBidPrices: List<ClusterNodeGroupSpotBidPrice>? = null,
    public val spotInstanceRemedy: Boolean? = null,
    public val subscriptionConfig: ClusterNodeGroupSubscriptionConfig? = null,
    public val systemDisk: ClusterNodeGroupSystemDisk,
    public val vswitchIds: List<String>? = null,
    public val withPublicIp: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroup): ClusterNodeGroup = ClusterNodeGroup(
            additionalSecurityGroupIds = javaType.additionalSecurityGroupIds().map({ args0 -> args0 }),
            autoScalingPolicy = javaType.autoScalingPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            costOptimizedConfig = javaType.costOptimizedConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupCostOptimizedConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataDisks = javaType.dataDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupDataDisk.Companion.toKotlin(args0)
                })
            }),
            deploymentSetStrategy = javaType.deploymentSetStrategy().map({ args0 -> args0 }).orElse(null),
            gracefulShutdown = javaType.gracefulShutdown().map({ args0 -> args0 }).orElse(null),
            instanceTypes = javaType.instanceTypes().map({ args0 -> args0 }),
            nodeCount = javaType.nodeCount(),
            nodeGroupName = javaType.nodeGroupName(),
            nodeGroupType = javaType.nodeGroupType(),
            nodeResizeStrategy = javaType.nodeResizeStrategy().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            spotBidPrices = javaType.spotBidPrices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupSpotBidPrice.Companion.toKotlin(args0)
                })
            }),
            spotInstanceRemedy = javaType.spotInstanceRemedy().map({ args0 -> args0 }).orElse(null),
            subscriptionConfig = javaType.subscriptionConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupSubscriptionConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemDisk = javaType.systemDisk().let({ args0 ->
                com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupSystemDisk.Companion.toKotlin(args0)
            }),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
            withPublicIp = javaType.withPublicIp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
