@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property constraints The constraints of auto scaling policy. See `constraints` below.
 * @property scalingRules The scaling rules of auto scaling policy. See `scaling_rules` below.
 */
public data class ClusterNodeGroupAutoScalingPolicy(
    public val constraints: ClusterNodeGroupAutoScalingPolicyConstraints? = null,
    public val scalingRules: List<ClusterNodeGroupAutoScalingPolicyScalingRule>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupAutoScalingPolicy): ClusterNodeGroupAutoScalingPolicy = ClusterNodeGroupAutoScalingPolicy(
            constraints = javaType.constraints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicyConstraints.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scalingRules = javaType.scalingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicyScalingRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
