@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property activityType The activity type of auto scaling policy. Valid values: `SCALE_OUT` and `SCALE_IN`.
 * @property adjustmentType The adjustment type of auto scaling policy. Valid values: `CHANGE_IN_CAPACITY` and `EXACT_CAPACITY`.
 * @property adjustmentValue The adjustment value of auto scaling policy. The value should between 1 and 5000.
 * @property metricsTrigger The trigger metrics of scaling rules for emr node group auto scaling policy. See `metrics_trigger` below.
 * @property minAdjustmentValue The minimum adjustment value of auto scaling policy.
 * @property ruleName The rule name of auto scaling policy.
 * @property timeTrigger The trigger time of scaling rules for emr node group auto scaling policy. See `time_trigger` below.
 * @property triggerType The trigger type of auto scaling policy. Valid values: `TIME_TRIGGER` and `METRICS_TRIGGER`.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRule(
    public val activityType: String,
    public val adjustmentType: String? = null,
    public val adjustmentValue: Int,
    public val metricsTrigger: ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger? = null,
    public val minAdjustmentValue: Int? = null,
    public val ruleName: String,
    public val timeTrigger: ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger? = null,
    public val triggerType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupAutoScalingPolicyScalingRule): ClusterNodeGroupAutoScalingPolicyScalingRule = ClusterNodeGroupAutoScalingPolicyScalingRule(
            activityType = javaType.activityType(),
            adjustmentType = javaType.adjustmentType().map({ args0 -> args0 }).orElse(null),
            adjustmentValue = javaType.adjustmentValue(),
            metricsTrigger = javaType.metricsTrigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger.Companion.toKotlin(args0)
                })
            }).orElse(null),
            minAdjustmentValue = javaType.minAdjustmentValue().map({ args0 -> args0 }).orElse(null),
            ruleName = javaType.ruleName(),
            timeTrigger = javaType.timeTrigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger.Companion.toKotlin(args0)
                })
            }).orElse(null),
            triggerType = javaType.triggerType(),
        )
    }
}
