@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property conditionLogicOperator The condition logic operator for this scaling rule specific metrics trigger. Valid values: `And` and `Or`.
 * @property conditions The conditions for this scaling rule specific metrics trigger. See `conditions` below.
 * @property coolDownInterval The time of cool down interval for this scaling rule specific metrics trigger.
 * @property evaluationCount The evaluation count for this scaling rule specific metrics trigger.
 * @property timeConstraints The time constraints for this scaling rule specific metrics trigger. See `time_constraints` below.
 * @property timeWindow The time window for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger(
    public val conditionLogicOperator: String? = null,
    public val conditions: List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition>? =
        null,
    public val coolDownInterval: Int? = null,
    public val evaluationCount: Int,
    public val timeConstraints: List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint>? = null,
    public val timeWindow: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger): ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger =
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTrigger(
                conditionLogicOperator = javaType.conditionLogicOperator().map({ args0 -> args0 }).orElse(null),
                conditions = javaType.conditions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition.Companion.toKotlin(args0)
                    })
                }),
                coolDownInterval = javaType.coolDownInterval().map({ args0 -> args0 }).orElse(null),
                evaluationCount = javaType.evaluationCount(),
                timeConstraints = javaType.timeConstraints().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerTimeConstraint.Companion.toKotlin(args0)
                    })
                }),
                timeWindow = javaType.timeWindow(),
            )
    }
}
